Name: startup
Version: 0.9.9.16
Release: alt1

Summary: The system startup scripts
License: GPL-2.0-or-later
Group: System/Base
BuildArch: noarch

Source: %name-%version.tar

Provides: /etc/firsttime.d
PreReq: chkconfig, gawk, grep, sed, coreutils
# due to sed -i
PreReq: sed >= 1:4.1.1
# Who could remind me where these dependencies came from?
Requires: findutils >= 0:4.0.33, mount >= 0:2.10q-ipl1mdk
Requires: procps >= 0:2.0.7-ipl5mdk, psmisc >= 0:19-ipl2mdk, util-linux >= 0:2.10q-ipl1mdk
# due to functions to resolve standalone systemd utilities
PreReq: service >= 0.5.32
# due to /sys
Requires: filesystem >= 0:2.1.7-alt1
# due to /bin/clock_unsynced
Requires: hwclock >= 1:2.14-alt1
# due to killall5 return code semantics and mountpoint utility (SysVinit >= 0:2.86-alt1)
Requires: sysvinit-utils
# due to fsck in rc.sysinit (ALT#22410)
Requires: /sbin/fsck
# due to /etc/modules move
Requires: /etc/modules
# due to /etc/sysctl.conf move
Requires: /etc/sysctl.conf

# due to systemd-sysctl, systemd-tmpfiles, and systemd-modules-load (see ALT#29537).
# We need a separate version of the utilities because they have less
# dependencies (see ALT#39444).
Requires: /sbin/systemd-modules-load
Requires: /sbin/systemd-sysctl
Requires: /sbin/systemd-tmpfiles

# due to update_wms
Conflicts: xinitrc < 0:2.4.13-alt1
# due to gen_kernel_headers
Conflicts: kernel-headers-common < 0:1.1
# due to netfs
Conflicts: net-scripts < 0:0.5.4-alt1
# due to /sbin/setsysfont's package change
Conflicts: interactivesystem < 1:sisyphus-alt12
# due to vconfig
Conflicts: vlan-utils < 0:1.9
# due to kexec support in halt
Conflicts: sysvinit < 2.88-alt4

%description
This package contains scripts used to boot your system,
change runlevels, and shut the system down cleanly.

%prep
%setup

%install
mkdir -p %buildroot%_sysconfdir/rc.d/rc{0,1,2,3,4,5,6}.d
install -p -m644 inittab %buildroot%_sysconfdir/
cp -a rc.d sysconfig %buildroot%_sysconfdir/

# these services do not support chkconfig:
# killall, halt, single local - Can't store symlinks in a CVS archive
ln -s ../init.d/killall %buildroot%_sysconfdir/rc.d/rc0.d/S00killall
ln -s ../init.d/killall %buildroot%_sysconfdir/rc.d/rc6.d/S00killall

ln -s ../init.d/halt %buildroot%_sysconfdir/rc.d/rc0.d/S01halt
ln -s ../init.d/halt %buildroot%_sysconfdir/rc.d/rc6.d/S01reboot

ln -s ../init.d/single %buildroot%_sysconfdir/rc.d/rc1.d/S00single

for i in `seq 2 5`; do
	ln -s ../init.d/local %buildroot%_sysconfdir/rc.d/rc$i.d/S99local
done

mkdir -p %buildroot/var/{log,run}
touch %buildroot{/etc/firsttime.flag,/var/{log/wtmp,run/utmp}}
touch %buildroot%_sysconfdir/sysconfig/{clock,i18n,system}
chmod -R +x %buildroot%_sysconfdir/rc.d
mkdir -p %buildroot%_sysconfdir/sysconfig/harddisk

mkdir -p %buildroot%_sysconfdir/firsttime.d

mkdir -p %buildroot%_localstatedir/random
touch %buildroot%_localstatedir/random/random-seed

%post
if [ $1 -eq 1 ]; then
	/sbin/chkconfig --add fbsetfont
	/sbin/chkconfig --add netfs
	/sbin/chkconfig --add random
	touch /etc/firsttime.flag
fi

for f in /var/{log/wtmp,run/utmp}; do
	if [ ! -f "$f" ]; then
		:>>"$f"
		chown root:utmp "$f"
		chmod 664 "$f"
	fi
done

%preun
if [ $1 -eq 0 ]; then
	/sbin/chkconfig --del fbsetfont
	/sbin/chkconfig --del netfs
	/sbin/chkconfig --del random
fi

%triggerpostun -- initscripts < 1:5.49.1-alt1
for f in %_sysconfdir/{inittab,sysconfig/{clock,framebuffer,i18n,init,mouse,system}}; do
	if [ ! -f "$f" ]; then
	        if [ -f "$f".rpmsave ]; then
	                cp -pf "$f".rpmsave "$f"
	        elif [ -f "$f".rpmnew ]; then
	                cp -pf "$f".rpmnew "$f"
	        fi
	fi
done
/sbin/chkconfig --add fbsetfont
/sbin/chkconfig --add netfs
/sbin/chkconfig --add random

%triggerpostun -- startup < 0:0.2-alt1
/sbin/chkconfig --add fbsetfont

%triggerpostun -- startup < 0:0.9.3-alt1
/sbin/chkconfig --add netfs

%files
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/sysconfig/*
%config(noreplace) %_sysconfdir/inittab
%config(missingok) %_sysconfdir/rc.d/rc?.d/*
%dir    %_sysconfdir/rc.d/scripts
%config %_sysconfdir/rc.d/scripts/*
%config %_sysconfdir/rc.d/init.d/*
%config %_sysconfdir/rc.d/rc
%config %_sysconfdir/rc.d/rc.sysinit
%config %_sysconfdir/rc.d/rc.powerfail
%ghost %attr(664,root,utmp) /var/log/wtmp
%ghost %attr(664,root,utmp) /var/run/utmp
%ghost %config(missingok) /etc/firsttime.flag
%dir %_sysconfdir/firsttime.d
%dir %_localstatedir/random
%ghost %config(noreplace,missingok) %verify(not md5 mtime size) %attr(600,root,root) %_localstatedir/random/random-seed

%changelog
