Name: tar
Version: 1.34.0.16.12d67f44
Release: alt1

Summary: A GNU file archiving program
License: GPLv3+
Group: Archiving/Backup
Url: https://www.gnu.org/software/tar/

%define srcname %name-%version-%release
# git://git.altlinux.org/gears/t/tar.git
Source: %srcname.tar

%def_enable selinux
BuildRequires: libacl-devel libattr-devel makeinfo
%{?_enable_selinux:BuildRequires: libselinux-devel}
BuildRequires: gnulib >= 0.1.4460.783f2, paxutils >= 0.0.1.139.2f7d

# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: /dev/pts}}

%description
The GNU tar program saves many files together into one archive and
can restore individual files (or all of the files) from the archive.
tar can also be used to add supplemental files to an archive and to
update or list files in the archive.  tar includes multivolume support,
automatic archive compression/decompression, the ability to perform
remote archives and the ability to perform incremental and full backups.

%prep
%setup -n %srcname

# Build scripts expect to find package version in this file.
echo -n %version-%release > .tarball-version

# Generate LINGUAS file.
ls po | sed -n 's/^\([^.]\+\)\.po$/\1/p' > po/LINGUAS

rmdir paxutils
ln -s %_datadir/paxutils .

%build
./bootstrap --force --skip-po --gnulib-srcdir=%_datadir/gnulib
export tar_cv_path_RSH=no
%configure --bindir=/bin --with-rmt=/sbin/rmt --disable-silent-rules
%make_build -C po update-po
%make_build AM_MAKEINFOFLAGS=--no-split

%install
mkdir -p %buildroot{%_bindir,%_man1dir}
%makeinstall_std bindir=/bin
ln -s ../../bin/tar %buildroot%_bindir/gtar
install -pm644 doc/tar.1 %buildroot%_man1dir/
%find_lang %name

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%check
%make_build -k check

%files -f %name.lang
/bin/tar
%_bindir/gtar
%_mandir/man?/*
%_infodir/tar.info*
%doc AUTHORS NEWS README THANKS TODO

%changelog
