Name: taucs
Version: 2.2
Release: alt11
Summary: C library of sparse linear solvers
License: MIT
Group: Sciences/Mathematics
Url: http://www.tau.ac.il/~stoledo/taucs/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar.gz

Requires: lib%name = %version-%release

BuildPreReq: liblapack-devel libmetis-devel
BuildPreReq: gcc-fortran

%description
TAUCS is a C library of sparse linear solvers.

Features: Multifrontal Supernodal Cholesky Factorization, Left-Looking
Supernodal Cholesky Factorization, Drop-Tolerance Incomplete-Cholesky
Factorization, LDL^T Factorization, Out-of-Core, Left-Looking Supernodal
Sparse Cholesky Factorization, Out-of-Core Sparse LU with Partial
Pivoting Factor and Solve, Ordering Codes and Interfaces to Existing
Ordering Codes, Matrix Operations, Matrix Input/Output, Matrix
Generators, Iterative Solvers, Vaidya's Preconditioners, Recursive
Vaidya's Preconditioners, Multilevel-Support-Graph Preconditioners.

%package doc
Summary: Documentation for TAUCS
Group: Documentation
BuildArch: noarch

%description doc
TAUCS is a C library of sparse linear solvers.

This package documentation for TAUCS.

%package -n lib%name
Summary: Shared library of TAUCS
Group: System/Libraries

%description -n lib%name
TAUCS is a C library of sparse linear solvers.

This package contains shared library of TAUCS.

%package -n lib%name-devel
Summary: Development files of TAUCS
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
TAUCS is a C library of sparse linear solvers.

This package contains development files of TAUCS.

%prep
%setup
rm -fR $(find ./ -name CVS) external/lib
rm -f progs/taucs_cilk_test.c

%build
./configure
%make_build
rm -fR bin
mkdir -p lib/linux/tmp
pushd lib/linux/tmp
ar x ../lib%name.a
g77 -shared * \
	-lmetis -llapack -lopenblas \
	-Wl,-soname,lib%name.so.0 -o ../lib%name.so.0.0.0
ln -s lib%name.so.0.0.0 ../lib%name.so.0
ln -s lib%name.so.0 ../lib%name.so
rm -f *
popd
rmdir lib/linux/tmp
%make_build

%install
install -d %buildroot%_bindir
for i in direct iter taucs_run; do
	install -m755 bin/linux/$i %buildroot%_bindir
done

install -d %buildroot%_libdir
cp -P lib/linux/* %buildroot%_libdir/

install -d %buildroot%_includedir
install -p -m644 src/*.h build/linux/*.h %buildroot%_includedir

install -d %buildroot%_docdir/%name
install -p -m644 doc/%name.pdf %buildroot%_docdir/%name

%files
%_bindir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%files doc
%_docdir/%name

%changelog
