%def_disable snapshot
%define _libexecdir %_prefix/libexec
%def_enable check

Name: telepathy-haze
Version: 0.8.1
Release: alt1

Summary: a connection manager built around libpurple
License: GPLv2+
Group: Networking/Instant messaging
Url: https://developer.pidgin.im/wiki/TelepathyHaze

%if_disabled snapshot
Source: https://telepathy.freedesktop.org/releases/%name/%name-%version.tar.gz
%else
Vcs: https://anongit.freedesktop.org/telepathy/telepathy-haze
Source: %name-%version.tar
%endif

BuildRequires(pre): rpm-build-python3
BuildRequires: glib2-devel >= 2.22 libgio-devel libdbus-glib-devel >= 0.73
BuildRequires: libpurple-devel >= 2.0.12 libtelepathy-glib-devel >= 0.13.9
BuildRequires: xsltproc
%if_enabled check
BuildRequires: python3-module-twisted-words python3-module-twisted-core-gui
BuildRequires: python3-module-cffi python3-module-service-identity
BuildRequires: python3-module-pygobject3-pygtkcompat
BuildRequires: /proc dbus-tools-gui python3-module-dbus
%endif

%description
telepathy-haze is a connection manager built around libpurple, the
core of Pidgin (formerly Gaim), as a Summer of Code project under the
Pidgin umbrella.  Ultimately, any protocol supported by libpurple will
be supported by telepathy-haze; for now, XMPP, MSN and AIM are known to
work acceptably, and others will probably work too.

%prep
%setup

%build
%autoreconf
%configure --disable-Werror PYTHON=%__python3
%make_build

%install
%makeinstall_std

%check
%make check

%files
%doc AUTHORS NEWS
%_libexecdir/%name
%_man8dir/*
%_datadir/dbus-1/services/org.freedesktop.Telepathy.ConnectionManager.haze.service

%changelog
