Name: thunar-media-tags-plugin
Version: 0.5.0
Release: alt1

Summary: Thunar media tags plugin
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/xfce/thunar/media-tags
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/thunar-plugins/thunar-media-tags-plugin.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libthunar-devel libxfce4util-devel
BuildRequires: libgtk+3-devel libtag-devel

%define _unpackaged_files_terminate_build 1

%description
The Thunar Media Tags Plugin (thunar-media-tags-plugin) adds special features
for media files to the Thunar File Manager.

Currently, these are:

* A bulk renamer option, which allows users to rename multiple audio files at
  once, based on their tags (e.g. ID3 or OGG/Vorbis),
* An audio tag editor which is reachable from the file properties page,
* A special media file page for the file properties dialog, which displays
  detailed information about quality, length, etc.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc README.md AUTHORS NEWS
%exclude %_libdir/thunarx-*/*.la
%_libdir/thunarx-*/*.so

# Seems glibc doesn't support uz@Latn
%exclude %_datadir/locale/uz@Latn/LC_MESSAGES/thunar-media-tags-plugin.mo

%changelog
