Name: tlp
Version: 1.8.0
Release: alt1

Summary: Optimize laptop battery life

License: GPLv2+
Group: System/Configuration/Hardware
Url: https://linrunner.de/tlp

Source: %name-%version.tar

BuildRequires: rpm-build-perl
BuildRequires: libsystemd-devel libudev-devel
BuildRequires: systemd systemd-analyze systemd-homed systemd-networkd

BuildRequires: libappstream-glib libappstream-glib-gir

#The following requires are not detected:
Requires: ethtool
Requires: hdparm
Requires: iw
Requires: rfkill
Requires: systemd systemd-analyze systemd-homed systemd-networkd
Requires: udev
Requires: usbutils
Requires: pciutils
Requires: cpupower linux-tools

#Note: Conflicts with laptop-mode-tools
#Makes sure laptop_mode isn't being used:
Conflicts: laptop-mode-tools

BuildArch: noarch

%description
TLP is a feature-rich command-line utility, saving laptop battery power
without the need to delve deeper into technical details.

TLPa.'s default settings are already optimized for battery life and implement
Powertopa.'s recommendations out of the box. Moreover TLP is highly
customizable to fulfil specific user requirements.

Settings are organized into two profiles, allowing to adjust between
savings and performance independently for battery (BAT) and AC operation.
In addition TLP can enable or disable Bluetooth, NFC, Wi-Fi and WWAN radio
devices on boot.

For ThinkPads and selected other laptops it provides a unified way
to configure charge thresholds and recalibrate the battery.

%package rdw
Group: System/Configuration/Hardware
Summary: Radio device wizard for TLP
Requires: NetworkManager-daemon >= 1.20
Requires: %name = %version-%release
BuildArch: noarch

%description rdw
Radio device wizard is an add-on to TLP. It provides event based
switching of bluetooth, NFC, Wi-Fi and WWAN radio devices on:
 - network connect/disconnect
 - dock/undock

%prep
%setup

%build
%make_build

%install
%makeinstall_std \
  TLP_SDSL=%_unitdir/../system-sleep \
  TLP_NMDSP=%_prefix/lib/NetworkManager/dispatcher.d \
  TLP_NO_INIT=1 \
  TLP_WITH_ELOGIND=0 \
  TLP_SYSD=%_unitdir \
  TLP_ULIB=%_udevrulesdir/..
#Install manpages:
%make_install install-man DESTDIR=%buildroot
%make_install install-man-rdw DESTDIR=%buildroot

%check
appstream-util validate-relax --nonet \
%buildroot/%_datadir/metainfo/*.xml

%files
%config(noreplace) %_sysconfdir/tlp.conf
%config(noreplace) %_sysconfdir/tlp.d
%doc --no-dereference LICENSE
%doc COPYING README.rst changelog
%_bindir/*
%exclude %_bindir/tlp-rdw
%_sbindir/*
%_mandir/man*/*
%exclude %_mandir/man*/tlp-rdw*
%_datadir/tlp
%_udevrulesdir/85-tlp.rules
%_udevrulesdir/../tlp-usb-udev
%_datadir/bash-completion/completions/*
%_datadir/fish/vendor_completions.d/*
%_datadir/zsh/site-functions/*
%exclude %_datadir/bash-completion/completions/tlp-rdw
%_unitdir/*.service
%_unitdir/../system-sleep
%_datadir/metainfo/*.metainfo.xml
%_sharedstatedir/tlp

%files rdw
%doc COPYING README.rst changelog
%_bindir/tlp-rdw
%_mandir/man*/tlp-rdw*
%_prefix/lib/NetworkManager/dispatcher.d/99tlp-rdw-nm
%_udevrulesdir/85-tlp-rdw.rules
%_udevrulesdir/../tlp-rdw-udev
%_datadir/bash-completion/completions/tlp-rdw

%post
%post_service tlp
if [ $1 -eq 2 ] ; then
    systemctl unmask systemd-rfkill.service
    systemctl unmask power-profiles-daemon.service
fi

%preun
%preun_service tlp
%changelog
