%define solib tolua++-5.3

Name: tolua++
Version: 1.0.93
Release: alt3
Summary: A tool to integrate C/C++ code with Lua
Group: System/Libraries
License: MIT
Url: https://github.com/LuaDist/toluapp
Packager: Vitaly Kuznetsov <vitty@altlinux.ru>

Source: http://www.codenix.com/~tolua/%name-%version.tar.bz2
Patch0: tolua++-1.0.93-no-buildin-bytecode.patch
Patch1: tolua++-1.0.93-lua53.patch
Patch2: tolua++-1.0.93-scons304.patch

BuildRequires: scons
BuildRequires: lua-devel >= 5.3

%description
tolua++ is an extended version of tolua, a tool to integrate C/C++ code with
Lua. tolua++ includes new features oriented to C++

%package devel
Summary: Development files for tolua++
Group: Development/C++
Requires: tolua++ = %version-%release
Requires: lua-devel >= 5.3

%description devel
Development files for tolua++

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
sed -i 's/\r//' doc/%name.html

%build
scons-3 %{?_smp_mflags} -Q CCFLAGS="%optflags  -I%_includedir" tolua_lib=%solib LINKFLAGS="-Wl,-soname,lib%solib.so" shared=1
#Recompile the exe without the soname. An ugly hack.
gcc -o bin/%name src/bin/tolua.o -Llib -l%solib -llua -ldl -lm

%install

mkdir -p %buildroot%_bindir
mkdir %buildroot%_libdir
mkdir %buildroot%_includedir
install -m0755 bin/%name  %buildroot%_bindir
install -m0755 lib/lib%solib.so %buildroot%_libdir
ln -s lib%solib.so %buildroot%{_libdir}/libtolua++.so
install -m0644 include/%name.h %buildroot%_includedir
# For use with Patch2 (not working yet)
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}
install -p -m 644 src/bin/lua/*.lua $RPM_BUILD_ROOT%{_datadir}/%{name}

%files
%doc README
%_libdir/lib%solib.so
%{_datadir}/%{name}

%files devel
%doc doc/*
%_bindir/%name
%_libdir/libtolua++.so
%_includedir/%name.h

%changelog
