%define _unpackaged_files_terminate_build 1

%define jss_version 4.9.5-alt1
%define tomcat_version 9.0.37
%define java_version 11

Name: tomcatjss
Version: 7.7.1
Release: alt1.p10.1

Summary: JSSE module for Apache Tomcat that uses JSS
License: LGPLv2+
Group: System/Libraries
# Source-git: https://github.com/dogtagpki/tomcatjss.git
Url: http://www.dogtagpki.org/wiki/TomcatJSS

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-macros-java
BuildRequires: /proc
BuildRequires: java-11-devel >= %java_version
BuildRequires: jpackage-11-compat
BuildRequires: apache-commons-logging
BuildRequires: ant
BuildRequires: jss >= %jss_version
BuildRequires: tomcat >= %tomcat_version

BuildArch: noarch
Requires: jss >= %jss_version
Requires: tomcat >= %tomcat_version
Requires: apache-commons-logging
Requires: java >= %java_version

%description
JSS Connector for Apache Tomcat, installed via the tomcatjss package,
is a Java Secure Socket Extension (JSSE) module for Apache Tomcat that
uses Java Security Services (JSS), a Java interface to Network Security
Services (NSS).

%prep
%setup
%autopatch -p1

%build

%install
# get Tomcat <major>.<minor> version number
tomcat_version=`/usr/sbin/tomcat version | sed -n 's/Server number: *\([0-9]\+\.[0-9]\+\).*/\1/p'`
app_server=tomcat-$tomcat_version

ant -v -f build.xml \
    -Dversion=%version \
    -Dsrc.dir=$app_server \
    -Djnidir=%_jnidir \
    -Dinstall.doc.dir=%buildroot%_docdir/%name-%version \
    -Dinstall.jar.dir=%buildroot%_javadir \
    install

%files
%doc README LICENSE
%_javadir/tomcatjss.jar
%_javadir/tomcatjss-%version.jar

%changelog
