%define _unpackaged_files_terminate_build 1

Name: topgit
Version: 0.9
Release: alt6.git20150225

Summary: A different patch queue manager for Git
License: GPLv2
Group: Development/Tools
Url: https://github.com/greenrd/topgit
BuildArch: noarch

Source0: topgit-%version.tar
Patch0: topgit-tg_rename.patch
Patch1: topgit-custom-merge.patch

%{?!_without_test:%{?!_disable_test:%{?!_without_check:%{?!_disable_check:BuildRequires: git-core}}}}

%description
TopGit aims to make handling of large amounts of interdependent topic
branches easier.  It is designed especially for the case
when you maintain a queue of third-party patches on top of another
(perhaps Git-controlled) project and want to easily organize, maintain
and submit them - TopGit achieves that by keeping a separate topic
branch for each patch and providing a few tools to maintain the branches.

TopGit has been designed around three main tenets:

(i) TopGit is as thin layer on top of Git as possible.
You still maintain your index and commit using Git, TopGit will
only automate few indispensable tasks.

(ii) TopGit is anxious about _keeping_ your history. It will
never rewrite your history and all metadata is also tracked by Git,
smoothly and non-obnoxiously. It is good to have a _single_ point
when the history is cleaned up, and that is at the point of inclusion
in the upstream project; locally, you can see how your patch has evolved
and easily return to older versions.

(iii) TopGit is specifically designed to work in distributed
environment. You can have several instances of TopGit-aware repositories
and smoothly keep them all up-to-date and transfer your changes between
them.

%prep
%setup
%patch0 -p1
rm -f .topdeps .topmsg # clean up topgit internal files
%patch1 -p1
rm -f .topdeps .topmsg # clean up topgit internal files

# TODO: the problem with topgit internal files should be solved.
# The problem is like this
# (http://www.altlinux.org/Git/MergingBranches#.D0.B2.D0.BC.D0.B5.D1.81.D1.82.D0.B5_.D1.81_gear):
#
# `tg export` exports nice patches, but it can't be called from `gear`.
# Gear is stupid and includes them in the patches.
#
# Possible solutions:
#
# * teach Gear to use topgit (extra dependency?);
# * modify TopGit not to store the meta-info (.topmsg, .topdeps)
#   in Git trees (https://github.com/greenrd/topgit/issues/38);
# * somehow adapt `tg export` to the needs of a Gear-based workflow
#   (some relevant remarks and objections:
#   https://github.com/greenrd/topgit/issues/42#issuecomment-75389885).

%build
touch --date=tomorrow precheck
%make_build prefix=%_prefix
rm -f precheck

%install
touch --date=tomorrow precheck
%makeinstall
rm -f precheck

%check
rm -f precheck
make precheck
# TODO: it has a check against a hardcoded Git version;
# we want to automatically add that version to RPM deps.

%files
%_bindir/*
%_datadir/%name
%_prefix/libexec/%name
%doc README COPYING

%changelog
