%define oname TuxMathScrabble
Name: tuxmathscrabble
Version: 0.7.4
Release: alt3

Summary: A math version of the popular board game for ages 4-40

Packager: Vitaly Lipatov <lav@altlinux.ru>

Group: Games/Boards
Url: http://sourceforge.net/projects/tuxmathscrabble/
License: GPLv3

BuildArch: noarch

%define pythonlibs %python_sitelibdir/%oname

%add_python_req_skip %oname

Source: http://prdownloads.sourceforge.net/tuxmathscrabble/%name-%version.tar

Patch: TuxMathScrabble-0.7.4-fixpath.patch

BuildRequires: rpm-build-python

# due font links
Requires: fonts-ttf-freefont

%description
TuxMathScrabble is an OpenSource math version of the popular board game for
ages 4-40. it challenges young people to construct compound equations and
consider multiple abstract possibilities. There are 4 skill levels, the
hardest uses numbers up to 20 and supports division as well as
add/subtract/multiply. Upon completing a successful move little Tux's
pop-out of the most recently moved tiles and do a little dance. Tux moves
his own pieces as well as performing various animated antics.

%prep
%setup
%patch

%__subst "s|#!/usr/bin/env python|#!/usr/bin/python2|" tuxmathscrabble.py

# replace font with links
rm -f Font/arial.ttf
rm -f Font/arialbd.ttf
ln -s /usr/share/fonts/ttf/freefont/FreeSans.ttf Font/arial.ttf
ln -s /usr/share/fonts/ttf/freefont/FreeSansBold.ttf Font/arialbd.ttf

%install
mkdir -p %buildroot%pythonlibs/
cp -a %oname/* %buildroot%pythonlibs/

mkdir -p %buildroot%_gamesdatadir/%oname/
cp -f .tms_config_master %buildroot%_gamesdatadir/%oname/
cp -a Font %buildroot%_gamesdatadir/%oname/

install -D %name.py %buildroot%_gamesbindir/%name

mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%name.desktop << EOF
[Desktop Entry]
Name=TuxMathScrabble
Comment=Fun game to learn math
Exec=%_gamesbindir/%name
Icon=%name
Terminal=false
Type=Application
Categories=Game;BoardGame;
EOF

%files
%_gamesbindir/%name
%pythonlibs/
%_gamesdatadir/%oname/
%_desktopdir/%name.desktop

%changelog
