Name: u-boot-meson
Version: 2023.07
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware

ExclusiveArch: aarch64

Source: %name-%version-%release.tar

BuildRequires: bc ccache dtc >= 1.7 flex libssl-devel

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports various AMLogic Meson family boards.

%prep
%setup

%build
export DTC=%_bindir/dtc
boards=$(grep -lr ARCH_MESON configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do
	O=build/${board}
	%make_build HOSTCC='ccache gcc' CC='ccache gcc' O=${O} ${board}_defconfig all
	install -pm0644 -D ${O}/u-boot.bin out/${board}/u-boot.bin
done

%install
mkdir -p %buildroot%_datadir/u-boot
cd out
find . -type f | cpio -pmd %buildroot%_datadir/u-boot

%files
%doc README doc/board/amlogic/*
%_datadir/u-boot/*

%changelog
