Name: u-boot-rockchip
Version: 2023.07
Release: alt2

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware

ExclusiveArch: aarch64

Source: %name-%version-%release.tar

BuildRequires: atf-rockchip >= 2.6 rk35-firmware
BuildRequires: bc ccache dtc >= 1.4 flex libssl-devel libuuid-devel libgnutls-devel
BuildRequires: python3(libfdt)
BuildRequires: python3(setuptools)
BuildRequires: python3(elftools.elf.elffile)

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports various Rockchip based boards.

%prep
%setup
egrep -lr 'CONFIG_ROCKCHIP_(PX30|RK3328|RK3399)' configs |xargs sed -i \
	-e '/^CONFIG_BAUDRATE/ s,1500000,115200,'

%build
export PYTHON=python3
export DTC=%_bindir/dtc

buildit()
{
  O=build/${board}
  BL31=%_datadir/atf/$1/bl31.elf \
  %make_build HOSTCC='ccache gcc' CC='ccache gcc' O=${O} ${board}_defconfig all
  install -pm0644 -D ${O}/u-boot-rockchip.bin out/${board}/u-boot-rockchip.bin
}

for soc in PX30 RK3328 RK3399; do
boards=$(fgrep -lr CONFIG_ROCKCHIP_${soc} configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do buildit ${soc,,[A-Z]}; done
done

export RKBIN=%_datadir/rkbin/bin/rk35
export ROCKCHIP_TPL=$RKBIN/rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.08.bin

for soc in RK3588; do
boards=$(fgrep -lr CONFIG_ROCKCHIP_${soc} configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do buildit ${soc,,[A-Z]}; done
done

%install
mkdir -p %buildroot%_datadir/u-boot
cd out 
find . -type f | cpio -pmd %buildroot%_datadir/u-boot

%files
%doc README doc/README.rockchip doc/board/rockchip
%_datadir/u-boot/*

%changelog
