%def_disable snapshot

%define _name udisks
%define api_ver 2.0
%define _libexecdir %_prefix/libexec
%define _localstatedir %_var

%def_enable introspection
%def_enable gtk_doc
%def_enable acl
# since 2.1.5 it is possible to configure udisks to mount devices
# in /media instead of /run/media but we use own control-based mechanism,
# so this option should never be enabled
%def_disable fhs_media
%def_enable lvm2
%def_disable iscsi
%def_enable btrfs
%def_disable lsm

Name: %{_name}2
Version: 2.10.1
Release: alt1

Summary: Disk Management Service (Second Edition)
License: GPL-2.0 and GPL-2.0-or-later and LGPL-2.0
Group: System/Servers
Url: https://github.com/storaged-project/udisks

%if_disabled snapshot
Source: https://github.com/storaged-project/%_name/releases/download/%_name-%version/%_name-%version.tar.bz2
%else
Source: %_name-%version.tar
%endif
Source1: %name.control
Patch20: udisks-2.10.0-disable-sanitize-log.patch

Obsoletes: %_name

%define glib_ver 2.68
%define gi_ver 1.30.1
%define polkit_ver 0.102
%define udev_ver 165
%define libatasmart_ver 0.17
%define dbus_ver 1.4.0
%define blockdev_ver 3.0.3
%define libmount_ver 2.30

Requires(pre): control
Requires: lib%name = %EVR
Requires: /lib/udev/rules.d
Requires: polkit
Requires: /usr/sbin/cryptsetup
Requires: dbus >= %dbus_ver dbus-tools-gui
# required dosfstools with compatibility symlinks
Requires: dosfstools >= 4.2-alt2
Requires: mdadm ntfsprogs parted gdisk xfsprogs nvme
%{?_enable_acl:Requires: acl}

Requires: libblockdev-fs >= %blockdev_ver
Requires: libblockdev-crypto >= %blockdev_ver
Requires: libblockdev-loop >= %blockdev_ver
Requires: libblockdev-mdraid >= %blockdev_ver
Requires: libblockdev-part >= %blockdev_ver
Requires: libblockdev-swap >= %blockdev_ver
Requires: libblockdev-nvme >= %blockdev_ver

BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libpolkit-devel >= %polkit_ver
BuildRequires: libatasmart-devel >= %libatasmart_ver
BuildRequires: libudev-devel libgudev-devel >= %udev_ver
BuildRequires: pkgconfig(systemd) libmount-devel >= %libmount_ver
BuildRequires: libblockdev-devel >= %blockdev_ver libblockdev-loop-devel
BuildRequires: libblockdev-mdraid-devel libblockdev-fs-devel libblockdev-crypto-devel
BuildRequires: libblockdev-part-devel libblockdev-swap-devel libblockdev-nvme-devel
BuildRequires: libuuid-devel
BuildRequires: libblkid-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_acl:BuildRequires: libacl-devel}
%{?_enable_lvm2:BuildRequires: libdevmapper-devel liblvm2-devel libblockdev-lvm-devel}
%{?_enable_iscsi:BuildRequires: iscsi-initiator-utils-devel}
%{?_enable_btrfs:BuildRequires: libblockdev-btrfs-devel}
%{?_enable_lsm:BuildRequires: libstoragemgmt-devel libconfig-devel}

%description
The udisks project provides a daemon, tools and libraries to access
and manipulate disks and storage devices.

%package -n lib%name
Summary: Dynamic library to access the udisks daemon (Second Edition)
Group: System/Libraries

%description -n lib%name
The udisks project provides a daemon, tools and libraries to access
and manipulate disks and storage devices.

This package contains the dynamic %name library, which provides
access to the udisks daemon.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains the development files for the library lib%name.

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the %name library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library

%package -n lib%name-devel-doc
Summary: Development documentation for lib%name
Group: Development/Documentation
Conflicts: %name < %version
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for lib%name.

%package module-lvm2
Summary: UDisks module for LVM2
Group: System/Servers
Requires: %name = %EVR
Requires: libblockdev-lvm >= %blockdev_ver

%description module-lvm2
This package contains UDisks module for LVM2 configuration.

%package module-btrfs
Summary: UDisks module for BTRFS
Group: System/Servers
Requires: %name = %EVR
Requires: libblockdev-btrfs >= %blockdev_ver

%description module-btrfs
This package contains UDisks module for BTRFS configuration.

%package module-lsm
Summary: UDisks module for LSM
Group: System/Servers
Requires: %name = %EVR
Requires: libstoragemgmt

%description module-lsm
This package contains UDisks module for LibStorageMgmt configuration.

%package module-iscsi
Summary: UDisks module for iSCSI
Group: System/Servers
Requires: %name = %EVR
Requires: iscsi-initiator-utils

%description module-iscsi
This package contains UDisks module for iSCSI configuration.


%prep
%setup -n %_name-%version
#%%patch20 -p2

%build
%autoreconf
%configure --disable-static \
	%{?_disable_gtk_doc:--enable-gtk-doc=no} \
	%{subst_enable acl} \
	%{?_enable_fhs_media:--enable-fhs-media} \
	%{subst_enable lvm2} \
	%{subst_enable iscsi} \
	%{subst_enable btrfs} \
	%{subst_enable lsm} \
%nil
%make_build

%install
%makeinstall_std

#mkdir -p %buildroot%_localstatedir/run/%name
touch %buildroot%_localstatedir/lib/%name/mtab

# use /media for mounting by default
mkdir -p %buildroot%_udevrulesdir
cat > %buildroot%_udevrulesdir/99-alt-%name-media-mount-point.rules <<_EOF_
ENV{ID_FS_USAGE}=="filesystem|other|crypto", ENV{UDISKS_FILESYSTEM_SHARED}="0"
_EOF_

# control support
install -pD -m755 %SOURCE1 %buildroot%_controldir/%name

%find_lang %name

%check
%make check VERBOSE=1

%pre
if [ -f %_controldir/%name ]; then
%pre_control %name
fi

%post
%post_control -s default %name

%files -f %name.lang
%_sbindir/umount.%name
%_bindir/udisksctl
%_udevrulesdir/80-%name.rules
%_udevrulesdir/99-alt-%name-media-mount-point.rules
%config(noreplace) %_sysconfdir/%name/%name.conf
%_sysconfdir/%name/mount_options.conf.example
%dir %_libexecdir/%name
%_libexecdir/%name/udisksd
%dir %_libdir/%name
%dir %_libdir/%name/modules
%_datadir/polkit-1/actions/org.freedesktop.UDisks2.policy
%_datadir/dbus-1/system.d/org.freedesktop.UDisks2.conf
%_datadir/dbus-1/system-services/org.freedesktop.UDisks2.service
%_datadir/bash-completion/completions/udisksctl
%_datadir/zsh/site-functions/_udisks2
%_man1dir/*
%_man5dir/%name.conf.5.*
%_man8dir/*
%attr(0700,root,root) %dir %_localstatedir/lib/%name
%ghost %_localstatedir/lib/%name/mtab
#%attr(0700,root,root) %dir %_localstatedir/run/%name
%config %systemd_unitdir/udisks2.service
%_tmpfilesdir/%name.conf
%config %_controldir/%name
%doc README.md AUTHORS NEWS HACKING

%files -n libudisks2
%_libdir/libudisks2.so.*

%files -n libudisks2-devel
%_libdir/lib%name.so
%_includedir/%name/
%_pkgconfigdir/%name.pc
%_pkgconfigdir/%name-btrfs.pc
%_pkgconfigdir/%name-lvm2.pc

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/udisks2/*
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/UDisks-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/UDisks-%api_ver.gir
%endif

%if_enabled lvm2
%files module-lvm2
%_libdir/%name/modules/lib%{name}_lvm2.so
%_datadir/polkit-1/actions/org.freedesktop.UDisks2.lvm2.policy
%endif

%if_enabled btrfs
%files module-btrfs
%_libdir/%name/modules/lib%{name}_btrfs.so
%_datadir/polkit-1/actions/org.freedesktop.UDisks2.btrfs.policy
%endif

%if_enabled lsm
%files module-lsm
%_libdir/%name/modules/lib%{name}_lsm.so
%_datadir/polkit-1/actions/org.freedesktop.UDisks2.lsm.policy
%endif

%if_enabled iscsi
%files module-iscsi
%_libdir/%name/modules/lib%{name}_iscsi.so
%_datadir/polkit-1/actions/org.freedesktop.UDisks2.iscsi.policy
%endif

%exclude %_libdir/%name/modules/*.la

%changelog
