Name: ulogd
Version: 2.0.7
Release: alt1

%def_disable nfacct

%define _unpackaged_files_terminate_build 1

Summary: ulogd - The userspace logging daemon for netfilter
Url: http://www.netfilter.org/projects/ulogd/
License: %gpl2plus
Group: System/Servers

Source: http://www.netfilter.org/projects/ulogd/files/%name-%version.tar
Source1: %name.init
Source2: %name.logrotate
Source3: %name.service
Patch0: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires: libpcap-devel zlib-devel libMySQL-devel postgresql-devel libsqlite3-devel libdbi-devel
BuildRequires: libnfnetlink-devel libmnl-devel libnetfilter_log-devel libnetfilter_conntrack-devel
%{?_enable_nfacct:BuildRequires: libnetfilter_acct-devel}

# For JSON plugin
BuildRequires: libjansson-devel

# For documentation
BuildRequires: linuxdoc-tools OpenSP

%description
Ulogd is an universal logging daemon for the ULOG target of netfilter, the
Linux 2.6 firewalling subsystem. Ulogd is able to log packets in various
formats to different targets (text files, databases, etc..). It has an
easy-to-use plugin interface to add new protocols and new output targets.

%package mysql
Summary: MySQL output plugin for ulogd
Group: System/Servers
Requires: %name = %version-%release

%description mysql
ulogd-mysql is a MySQL output plugin for ulogd. It enables logging of
firewall information into a MySQL database.

%package pgsql
Summary: PostgreSQL output plugin for ulogd
Group: System/Servers
Requires: %name = %version-%release

%description pgsql
ulogd-pgsql is a PostgreSQL output plugin for ulogd. It enables logging of
firewall information into a PostgreSQL database.

%package sqlite3
Summary: SQLite3 output plugin for ulogd
Group: System/Servers
Requires: %name = %version-%release

%description sqlite3
ulogd-sqlite3 is a SQLite output plugin for ulogd. It enables logging of
firewall information into a SQLite v.3 database.

%package dbi
Summary: Libdbi framework output plugin for %name
Group: System/Servers
Requires: %name = %version-%release

%description dbi
%name-dbi is a libdbi output plugin for %name. It enables logging of
firewall information through a libdbi interface.

%prep
%setup
%patch0 -p1

%build
#export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%autoreconf
%configure \
	--disable-static \
	--with-dbi-lib=%_libdir \
	--with-jansson \
	%{subst_enable nfacct}

make DESTDIR=%buildroot
make -C doc
#rm -f ulogd
#export LDFALGS="-pie"
#make ulogd

%install
mkdir -p %buildroot/%_logdir/%name
mkdir -p %buildroot/%_sysconfdir
mkdir -p %buildroot/%_libdir/%name
mkdir -p %buildroot/%_sbindir
%makeinstall_std

mkdir -p %buildroot/%_sysconfdir/rc.d/init.d
install %SOURCE1 %buildroot/%_sysconfdir/rc.d/init.d/%name

install -pDm644 %SOURCE3 %buildroot/%_unitdir/%name.service

install -pDm644 %SOURCE2 %buildroot/%_sysconfdir/logrotate.d/%name

mkdir -p %buildroot/%_datadir/%name
install -pm644 doc/*.sql %buildroot/%_datadir/%name/
install -pm644 doc/sqlite3.table %buildroot/%_datadir/ulogd/
mkdir -p %buildroot/%_localstatedir/ulogd/

mkdir -p %buildroot/%_man8dir
install -pm644 %name.8 %buildroot/%_man8dir/%name.8

install -Dm0640 %name.conf %buildroot%_sysconfdir/%name.conf

%if_disabled nfacct
sed -i -r 's;^(plugin="%_libdir/ulogd/ulogd_inpflow_NFACCT\.so");#\1;' %buildroot%_sysconfdir/%name.conf
%endif

%pre
%_sbindir/groupadd -r -f %name >/dev/null 2>&1
%_sbindir/useradd -r -n -g %name -d /dev/null -s /dev/null %name >/dev/null 2>&1 ||:

%preun
%preun_service %name

%files
%attr(0755,root,root) %_sbindir/%name
%attr(0640,root,%name) %config(noreplace) %_sysconfdir/%name.conf
%_sysconfdir/rc.d/init.d/%name
%_unitdir/%name.service
%config(noreplace) %_sysconfdir/logrotate.d/%name
%dir %_libdir/%name
%attr(1770,root,ulogd) %_logdir/%name
%_libdir/%name/*.so
%doc COPYING AUTHORS README
%doc doc/%name.txt doc/%name.html
%_man8dir/*
%attr(1770,root,ulogd) %_localstatedir/%name/
%dir %_datadir/%name/
%exclude  %_libdir/%name/*.la
%exclude %_libdir/%name/ulogd_output_MYSQL.so
%exclude %_libdir/%name/ulogd_output_PGSQL.so
%exclude %_libdir/%name/ulogd_output_SQLITE3.so
%exclude %_libdir/%name/ulogd_output_DBI.so

%files mysql
%_libdir/%name/ulogd_output_MYSQL.so
%_datadir/%name/mysql-*.sql

%files pgsql
%_libdir/%name/ulogd_output_PGSQL.so
%_datadir/%name/pgsql-*.sql

%files sqlite3
%_libdir/%name/ulogd_output_SQLITE3.so
%_datadir/%name/sqlite3.table

%files dbi
%_libdir/%name/ulogd_output_DBI.so

%changelog
