%define kernel_version   5.10
%define kernel_source /usr/src/kernel/sources/kernel-source-%kernel_version.tar
%define source_dir tools/usb/usbip
%define lname lib%name

%def_disable static

Name: usbip
Version: %kernel_version
Release: alt1

Summary: Utility for manage usbip devices

Group: System/Configuration/Networking
License: GPLv2+
Url: http://www.kernel.org

# used sources from kernel-source package
Source: %name-%version.tar

# Systemd units from Fedora
# TODO: maybe make a systemd user service for usbip, sth like usbip@.service?
# https://wiki.archlinux.org/index.php/USB/IP#Client_setup

Packager: Pavel Vainerman <pv@altlinux.org>

BuildRequires(pre): rpm-macros-systemd
BuildRequires: libudev-devel
BuildRequires: kernel-source-%kernel_version

Obsoletes: %name-client < %EVR
Provides:  %name-client = %EVR


%description
The USB/IP Project aims to develop a general USB device sharing system
over IP network. To share USB devices between computers with their full
functionality, USB/IP encapsulates "USB requests" into IP packets and
transmits them between computers. Original USB device drivers and
applications can be also used for remote USB devices without any
modification of them. A computer can use remote USB devices as if they
were directly attached; for example, we can:
  - USB storage devices: fdisk, mkfs, mount/umount, file operations,
    play a DVD movie and record a DVD-R media.
  - USB keyboards and USB mice: use with linux console and X Window
    System.
  - USB webcams and USB speakers: view webcam, capture image data and
    play some music.
  - USB printers, USB scanners, USB serial converters and USB Ethernet
    interfaces: ok, use fine.

%package server
Summary: %name server daemon
Group: System/Configuration/Networking
Requires: %lname = %EVR
Obsoletes: %{name}d < %EVR
Provides:  %{name}d = %EVR

%description server
The USB/IP Project aims to develop a general USB device sharing system
over IP network. To share USB devices between computers with their full
functionality, USB/IP encapsulates "USB requests" into IP packets and
transmits them between computers. Original USB device drivers and
applications can be also used for remote USB devices without any
modification of them. A computer can use remote USB devices as if they
were directly attached; for example, we can:
  - USB storage devices: fdisk, mkfs, mount/umount, file operations,
    play a DVD movie and record a DVD-R media.
  - USB keyboards and USB mice: use with linux console and X Window
    System.
  - USB webcams and USB speakers: view webcam, capture image data and
    play some music.
  - USB printers, USB scanners, USB serial converters and USB Ethernet
    interfaces: ok, use fine.

%{name} server daemon.

%package -n %lname
Summary: %name shared library
Group: System/Libraries
#Requires: %_datadir/hwdata
Requires: hwdata

%description -n %lname
%name shared library.

%package -n %lname-devel
Summary: %name devel files
Group: Development/C

%description -n %lname-devel
%name devel files.

%package -n %lname-devel-static
Summary: %name static library
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
%name static library.


%prep
%setup
tar -xvf %kernel_source kernel-source-%kernel_version/%source_dir
cp -rf kernel-source-%kernel_version/%source_dir/* ./
rm -rf kernel-source-%kernel_version

%build
 %__subst 's| -Werror||g' configure.ac
./autogen.sh
%add_optflags -fcommon
%configure %{subst_enable static} --with-usbids-dir=%_datadir/hwdata
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_sysconfdir/sysconfig
mkdir -p %buildroot%_unitdir

install -Dp -m644 usbipd %buildroot%_sysconfdir/sysconfig/%{name}d
install -Dp -m644 usbipd.service %buildroot%_unitdir/%{name}d.service
ln -s %{name}d.service %buildroot%_unitdir/%{name}-server.service
install -Dp -m644 usbip-client.service %buildroot%_unitdir/%{name}-client.service

# Make usbip be inside PATH on client, it does not require root
mkdir -p %buildroot%_bindir
ln -s ../sbin/usbip %buildroot%_bindir/usbip


%post
%systemd_post usbip-client.service

%preun
%systemd_preun usbip-client.service

%postun
%systemd_postun_with_restart usbip-client.service

%post server
%systemd_post usbipd.service

%preun server
%systemd_preun usbipd.service

%postun server
%systemd_postun_with_restart usbipd.service


%files
%doc README
%_bindir/%name
%_sbindir/%name
%_unitdir/%{name}-client.service
%_man8dir/usbip.8*

%files server
%_sbindir/%{name}d
%_sysconfdir/sysconfig/%{name}d
%_unitdir/%{name}d.service
%_unitdir/%{name}-server.service
%doc README
%_man8dir/usbipd.8*

%files -n %lname
%_libdir/libusbip.so.*

%files -n %lname-devel
%_includedir/*
%_libdir/libusbip.so

%if_enabled static
%files -n %lname-devel-static
%_libdir/libusbip.a
%endif

%changelog
