# We don't build with Gnome support by default to avoid a GConf dependency.
# If you would like to set the Gnome background image with Viewnior, rebuild
# the srpm with:
#   rpmbuild --rebuild viewnior-*-src.rpm --with gnome
%def_without gnome

Name: viewnior
Version: 1.7
Release: alt1

Summary: Elegant image viewer
License: GPLv3+
Group: Graphics

Url: http://xsisqox.github.com/Viewnior
Source0: %name-%version.tar.gz
Source1: %name.watch
Patch0:         fix-appdata.patch

Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Sun Apr 13 2014
# optimized out: fontconfig fontconfig-devel glib2-devel gnu-config libatk-devel libcairo-devel libcloog-isl4 libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libstdc++-devel libwayland-client libwayland-server perl-Encode perl-XML-Parser pkg-config
BuildRequires: gcc-c++ intltool libexiv2-devel libgtk+2-devel
BuildRequires:  meson

%if_with gnome
BuildRequires: libGConf-devel
%endif

%description
Viewnior is an image viewer program. Created to be simple, fast
and elegant.  It's minimalistic interface provides more screen
space for your images. Among its features are:
* Fullscreen & Slideshow
* Rotate, flip, save, delete images
* Animation support
* Browse only selected images
* Navigation window
* Simple interface
* Configurable mouse actions

%prep
%setup -n Viewnior-%name-%version
%patch0 -p1
# fix spurious executable perms
chmod 644 AUTHORS COPYING NEWS README.md TODO src/*


%build
%meson

%meson_build

%install
%meson_install



%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README.md TODO
%_bindir/%name
%_man1dir/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/%name.*
%_datadir/%name/
%{_datadir}/appdata/%{name}.appdata.xml

%changelog
