
Name: vzctl
Version: 7.0.248
Release: alt1

Summary: OpenVZ Virtual Environments control utility
License: GPLv2
Group: System/Configuration/Other
Url: http://openvz.org/
Vcs: https://src.openvz.org/scm/ovzl/vzctl.git

Packager: Andrew A. Vasilyev <andy@altlinux.org>

Source: %name-%version.tar
Patch: %name-%version.patch

ExclusiveArch: x86_64

# these reqs are for vz helper scripts
Requires: ploop >= 7.0.199
Requires: network-config-subsystem
Requires: libvzctl >= 7.0.659

BuildRequires(pre): rpm-build-python3
BuildRequires: glibc-devel libuuid-devel
BuildRequires: systemd-devel libudev-devel
BuildRequires: libvzctl-devel >= 7.0.639
BuildRequires: libploop-devel >= 7.0.199
BuildRequires: kernel-headers-ovz-el7 >= 3.10.0

%define _libexecdir /usr/libexec
%define vzdir /etc/vz
%define confdir %vzdir/conf
%define namesdir %vzdir/names
%define lockdir /var/lib/vz/lock
%define vzctl_lockdir /var/lock/vzctl
%define spooldir /var/lib/vz
%define netdir /etc/sysconfig/network-scripts
%define bashcompldir /etc/bash_completion.d

%description
OpenVZ is an Operating System-level server virtualization solution, built
on Linux.  OpenVZ creates isolated, secure virtual private servers on a
single physical server enabling better server utilization and ensuring
that applications do not conflict.  Each VE performs and executes exactly
like a stand-alone server; VEs can be rebooted independently and have
root access, users, IP addresses, memory, processes, files, applications,
system libraries and configuration files.

This package contain the control tool to manipulate
OpenVZ Virtual Environments.

%prep
%setup
%patch -p1

%build
%make CFLAGS="%optflags -D_GNU_SOURCE -DVERSION=\\\"%version\\\""

%install
make install \
	DESTDIR=%buildroot \
	SBINDIR=%_sbindir \
	MANDIR=%_mandir \
	SYSTEMDDIR=%_unitdir \
	NETSCRIPTDIR=%netdir \
	VZDIR=%vzdir \
	CONFDIR=%confdir \
	VZLOCKDIR=%lockdir \
	VZCTLLOCKDIR=%vzctl_lockdir \
	VZSPOOLDIR=%spooldir \
	BASHCOMPLDIR=%bashcompldir \
	LOGRDIR=%_logrotatedir

ln -s -r %buildroot%_unitdir/vzevent.service %buildroot%_unitdir/vzeventd.service

%post
%post_service vzeventd

# Load sysctls
sysctl -p /etc/sysctl.d/99-vzctl.conf > /dev/null 2>&1

# First installation, not upgrade.
#if [ $1 -eq 1 ]; then
#	# Insert iptables rules.
#	%_libexecdir/vz-iptables-config.py add > /dev/null 2>&1
#fi
exit 0

%preun
%preun_service vz
%preun_service vzeventd
%preun_service vz-k8s-inside-ct
# Last deinstallation, not upgrade.
#if [ $1 -eq 0 ]; then
#	# Remove iptables rules.
#	%_libexecdir/vz-iptables-config.py remove > /dev/null 2>&1
#fi

%files
%dir %vzdir
%dir %confdir
%dir %namesdir
%dir %vzdir/dev
%vzdir/vzevent.d
%attr(700,root,root) %lockdir
%spooldir
%bashcompldir/*
%_target_libdir_noarch/dracut/modules.d/*
%_sbindir/*
%_unitdir/*.service
#%%_initdir/*
%_libexecdir/vz
%_libexecdir/vz-k8s-inside-ct
%config(noreplace) %_logrotatedir/vzctl
%confdir/*sample
%_man8dir/*
%_man5dir/*

%config(noreplace) %confdir/networks_classes
%config(noreplace) %vzdir/vz.conf
%config(noreplace) %_sysconfdir/modprobe.d/*.conf
%config %_sysconfdir/sysctl.d/*.conf
%config %_sysconfdir/modules-load.d/*.conf

%changelog
