%define wdm_config wdm-config-1.20

Name: wdm
Version: 1.28
Release: alt21

Summary: WINGs Display Manager
License: GPL
Group: Graphical desktop/Window Maker
Url: http://voins.program.ru/wdm

Source0: %name-%version-%release.tar.bz2
Source1: %wdm_config.tar.bz2
Source2: wdm-alt-logo.png
Source3: wdmLocale
Source4: wdm.firsttime
Patch: wdm-config.patch

Requires: %_bindir/xvt

# Automatically added by buildreq on Mon Mar 30 2009
BuildRequires: libWINGs-devel libXau-devel libXdmcp-devel libXmu-devel libaudit-devel libdbus-devel libpam-devel libXext-devel libSM-devel libICE-devel
# was missing in build environment, if it will cause trouble, disable in configure
BuildRequires: libXinerama-devel
BuildPreReq: libtiff-devel libXpm-devel libpng-devel libjpeg-devel
BuildPreReq: libungif-devel libXft-devel

%description
Wdm combines the functions of a graphical display manager identifying
and authenticating a user on a system with some of the functions of a
session manager in selecting and starting a window manager. Optionally,
wdm can shutdown (reboot or halt) the system.

%prep
%setup -a 1 -n %name-%version-%release
%patch -p1


%build
%autoreconf
export XRDB_PATH=%_bindir/xrdb
export XCONSOLE=%_bindir/xconsole
export SHUTDOWN=/sbin/shutdown
export FAILSAFE_PATH=%_bindir/xvt
export DEF_SERVER=%_bindir/X
export SYSTEM_SHELL=/bin/sh
export SHELL_BASH=/bin/bash
%configure \
	--enable-pam \
	--enable-aafont \
	--enable-consolekit \
	--with-libaudit \
	--with-wdmdir=%_sysconfdir/X11/wdm \
	--with-nlsdir=%_datadir/locale \
	--with-gfxdir=%_datadir/pixmaps/wdm \
	--with-fakehome=%_localstatedir/wdm
%make

%install
%makeinstall_std

rm -rf %buildroot%_sysconfdir/X11/wdm/X*
rm -rf %buildroot%_sysconfdir/X11/wdm/wdm*
rm -rf %buildroot%_sysconfdir/X11/wdm/GiveConsole
rm -rf %buildroot%_sysconfdir/X11/wdm/TakeConsole

install -pD -m600 %wdm_config/wdm.pamd %buildroot%_sysconfdir/pam.d/wdm
install -pD -m755 %wdm_config/wdm.wms %buildroot%_sysconfdir/X11/wms-methods.d/wdm
install -pD -m644 %wdm_config/Xaccess %buildroot%_sysconfdir/X11/wdm/Xaccess
install -pD -m644 %wdm_config/Xresources %buildroot%_sysconfdir/X11/wdm/Xresources
install -pD -m644 %wdm_config/Xservers %buildroot%_sysconfdir/X11/wdm/Xservers
install -pD -m755 %wdm_config/Xsession %buildroot%_sysconfdir/X11/wdm/Xsession
install -pD -m755 %wdm_config/Xsetup_0 %buildroot%_sysconfdir/X11/wdm/Xsetup_0
install -pD -m600 %wdm_config/wdm-config %buildroot%_sysconfdir/X11/wdm/wdm-config
install -pD -m600 %wdm_config/wdmLogin-config %buildroot%_sysconfdir/X11/wdm/wdmLogin-config
install -pD -m755 %wdm_config/GiveConsole %buildroot%_sysconfdir/X11/wdm/GiveConsole
install -pD -m755 %wdm_config/TakeConsole %buildroot%_sysconfdir/X11/wdm/TakeConsole
install -pD -m644 %_sourcedir/wdm-alt-logo.png %buildroot%_datadir/pixmaps/wdm/wdm-alt-logo.png


rm -rf %buildroot%_sysconfdir/X11/wdm/authdir
mkdir -p %buildroot%_localstatedir/wdm
ln -s -f ../../..%_localstatedir/wdm %buildroot%_sysconfdir/X11/wdm/authdir

mkdir -p %buildroot%_sysconfdir/logrotate.d
cat << EOF > %buildroot%_sysconfdir/logrotate.d/wdm
%_logdir/wdm-error.log {
	notifempty
	missingok
	nocompress
}
EOF

%find_lang %name

install -pDm755 %SOURCE3 %buildroot%_bindir/wdmLocale
install -pDm755 %SOURCE4 %buildroot%_sysconfdir/firsttime.d/wdm

%pre
[ -d %_sysconfdir/X11/wdm/authdir -a -L %_sysconfdir/X11/wdm/authdir ] ||
  rm -rf -- %_sysconfdir/X11/wdm/authdir

%post
[ -n "$DURING_INSTALL" ] || %_sysconfdir/firsttime.d/wdm ||:

%files -f %name.lang
%_bindir/wdm
%_bindir/wdmLogin
%_bindir/wdmLocale
%_man1dir/*
%_sysconfdir/firsttime.d/wdm
%_sysconfdir/logrotate.d/wdm
%_sysconfdir/X11/wms-methods.d/wdm
%dir %_sysconfdir/X11/wdm
%config %_sysconfdir/pam.d/wdm
%config(noreplace) %_sysconfdir/X11/wdm/wdm-config
%config(noreplace) %_sysconfdir/X11/wdm/wdmLogin-config
%_sysconfdir/X11/wdm/authdir
%_datadir/pixmaps/wdm
%_sysconfdir/X11/wdm/GiveConsole
%_sysconfdir/X11/wdm/TakeConsole
%config(noreplace) %_sysconfdir/X11/wdm/X*
%dir %_localstatedir/wdm
%doc AUTHORS ChangeLog INSTALL NEWS README README.pam TODO

%changelog
