%define soversion 199
Name: x265
Version: 3.5
Release: alt1.1
Summary: H.265/HEVC encoder
License: GPLv2
Group: Video
Url: http://x265.org
Requires: libx265-%soversion = %version-%release
Source: %name-%version-%release.tar
Patch0: x265-high-bit-depth-soname.patch
Patch1: x265-pic.patch
Patch2: x265-arm-cflags.patch
Patch3: x265-detect_cpu_armhfp.patch
BuildRequires: cmake gcc-c++ nasm libnuma-devel

%description
H.265/HEVC encoder

%package -n libx265-%soversion
Summary: H.265/HEVC encoder library
Group: System/Libraries
Obsoletes: libx265 = 2.5-alt1

%package -n libx265-devel
Summary: Development files of H.265/HEVC encoder library
Group: Development/C
Requires: libx265-%soversion = %version-%release

%description -n libx265-%soversion
H.265/HEVC encoder library

%description -n libx265-devel
Development files of H.265/HEVC encoder library

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

sed -i	-e '/X265_VERSION / s,unknown,%version,' \
	-e '/X265_LATEST_TAG / s,0\.0,%version,' \
	-e '/^#Find version control software.*/i return()' \
	source/cmake/Version.cmake

%build
%add_optflags %optflags_shared
%define _cmake__builddir $builddir
build() {
%cmake \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DLIB_INSTALL_DIR=%_lib \
	-DCMAKE_SKIP_RPATH:BOOL=YES \
	-DCMAKE_POSITION_INDEPENDENT_CODE:BOOL=ON \
	-DENABLE_PIC:BOOL=ON \
	-DENABLE_TESTS:BOOL=ON \
	-DCMAKE_ASM_NASM_FLAGS=-w-macro-params-legacy \
	-DENABLE_SHARED=ON \
	$* \
	-S source
%cmake_build
}

%ifarch x86_64 aarch64 ppc64 ppc64le
builddir=10bit
    build \
    -DENABLE_CLI=OFF \
    -DENABLE_ALTIVEC=OFF \
    -DHIGH_BIT_DEPTH=ON

builddir=12bit
    build \
    -DENABLE_CLI=OFF \
    -DENABLE_ALTIVEC=OFF \
    -DHIGH_BIT_DEPTH=ON \
    -DMAIN12=ON
%endif

# 8 bit base library + encoder
builddir=8bit
    build -DENABLE_HDR10_PLUS=YES \
    %ifarch %ix86
      -DENABLE_ASSEMBLY=OFF \
    %endif
    #

%install
%define _cmake__builddir ${i}bit
for i in 8 10 12; do
    if [ -d ${i}bit ]; then
            %cmake_install
            # Remove unversioned library, should not be linked to
            rm -f %buildroot%_libdir/libx265_main${i}.so
    fi
done

find %buildroot -name "*.a" -delete

%check
for i in 8 10 12; do
    if [ -d ${i}bit ]; then
        pushd ${i}bit
            test/TestBench || :
        popd
    fi
done

%files
%_bindir/x265

%files -n libx265-%soversion
%_libdir/libx265.so.%soversion
%ifarch x86_64 aarch64 ppc64 ppc64le
%{_libdir}/libx265_main10.so.%soversion
%{_libdir}/libx265_main12.so.%soversion
%endif

%files -n libx265-devel
%_libdir/libx265.so
%_libdir/libhdr10plus.so
%_includedir/x265.h
%_includedir/hdr10plus.h
%_includedir/x265_config.h
%_pkgconfigdir/*

%changelog
