Name: xaos
Version: 3.6
Release: alt3
Summary: A real-time fractal zoomer
Serial: 1

License: GPLv3+

Group: Sciences/Mathematics
Url: http://xaos.sourceforge.net
Packager: Igor Vlasenko <viy@altlinux.org>
Source0: http://prdownloads.sourceforge.net/xaos/xaos-%version.tar.gz
Source1: xaos.png
Source10: %name.16.xpm.bz2
Source11: %name.32.xpm.bz2
Source12: %name.48.xpm.bz2

Patch1: xaos-3.6-upstream-desktop.patch
Patch2: xaos-3.6-upstream-fortify.patch
Patch3: xaos-3.6-upstream-gcc.patch
Patch4: xaos-3.6-upstream-parallel-build.patch
Patch5: xaos-3.6-upstream-qt5.patch

Provides : XaoS = %version, %name-aalib = %version
Obsoletes: XaoS, %name-aalib

# Automatically added by buildreq on Wed Feb 27 2019 (-bi)
# optimized out: aalib elfutils fontconfig fontconfig-devel glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libX11-devel libXext-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libpng-devel pkg-config python-base python-modules tex-common texlive xorg-proto-devel xz zlib-devel
BuildRequires: aalib-devel imake libICE-devel libgsl-devel libgtk+2-devel texlive-collection-basic xorg-cf-files

%description
XaoS is a real-time fractal zoomer. It is highly optimized. It features an
advanced help system and nice tutorial about a lot different fractals.

This package holds the binary that runs with X11.

%prep
%setup -q -n xaos-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
# disable stripping binaries when installing
sed -i 's| -s | |' Makefile.in
sed -i 's,\$x_includes/X11/extensions/XShm.h,/usr/include/X11/extensions/XShm.h,' configure.in configure

%build
%ifarch %ix86 x86_64
%define long_double --with-long-double
%endif
%configure \
   --with-x11-driver \
    --with-gsl=yes \
    --with-sffe=yes \
    --with-gtk-driver=yes \
    --with-aa-driver=yes \
    --with-pthread=yes \
    %{long_double}
# due to the buggy configure it has the opposite effect
#    --with-png=yes \
%make

%install
mkdir -p %buildroot%_infodir
%makeinstall LOCALEDIR=%buildroot%_datadir/locale

pushd doc
make xaos.dvi
dvipdfm xaos.dvi
popd
pushd help
make html
popd

%if_with aalib
install -m755 xaos-aalib %buildroot%_bindir
%endif

%if_with svgalib
install -m755 xaos-svgalib %buildroot%_bindir
%endif

install -m644 help/xaos.hlp %buildroot%_datadir/XaoS/catalogs

# menu entry
sed -i 's:Exec=xaos:Exec=xaos -driver "GTK+ Driver":' src/xdg/xaos.desktop
echo 'Encoding=UTF-8' >> src/xdg/xaos.desktop
echo 'Version=1.0' >> src/xdg/xaos.desktop

install -m755 -d %buildroot%_desktopdir/
install -m644 src/xdg/xaos.desktop %buildroot%_desktopdir/%name.desktop

# icon
mkdir -p %buildroot%_miconsdir
mkdir -p %buildroot%_liconsdir
mkdir -p %buildroot%_niconsdir
bzcat %SOURCE10 > %buildroot%_miconsdir/%name.xpm
bzcat %SOURCE11 > %buildroot%_niconsdir/%name.xpm
bzcat %SOURCE12 > %buildroot%_liconsdir/%name.xpm
cp %SOURCE1 %buildroot%_liconsdir/%name.png

%find_lang %name

%files -f %name.lang
%doc README COPYING TODO ChangeLog NEWS
%doc AUTHORS doc/xaos.pdf

%_bindir/%name
%_datadir/XaoS
%_mandir/man6/*
%_infodir/*.info*
%_desktopdir/%name.desktop
%_miconsdir/%name.xpm
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm
%_liconsdir/%name.png

%changelog
