Epoch: 0
Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-alternatives rpm-macros-java
# END SourceDeps(oneline)
AutoReq: yes,noosgi
BuildRequires: rpm-build-java-osgi
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define __requires_exclude system.bundle

Name:          xerces-j2
Version:       2.12.1
Release:       alt1_3jpp11
Summary:       Java XML parser
# Most of the source is ASL 2.0
# W3C licensed files:
# src/org/apache/xerces/dom3/as
# src/org/w3c/dom/html/HTMLDOMImplementation.java
License:       ASL 2.0 and W3C
URL:           http://xerces.apache.org/xerces2-j/

%global cvs_version %(tr . _ <<< %{version})

Source0:       http://mirror.ox.ac.uk/sites/rsync.apache.org/xerces/j/source/Xerces-J-src.%{version}.tar.gz
Source1:       http://www.apache.org/dist/xerces/j/source/Xerces-J-src.%{version}.tar.gz.asc
Source2:       http://www.apache.org/dist/xerces/j/binaries/KEYS
Source11:      %{name}-version.1
Source12:      %{name}-constants.1

# Custom javac ant task used by the build
Source3:       https://svn.apache.org/repos/asf/xerces/java/tags/Xerces-J_%{cvs_version}/tools/src/XJavac.java

Source7:       %{name}-pom.xml

# Patch the build so that it doesn't try to use bundled xml-commons source
Patch0:        %{name}-build.patch

# Patch the manifest so that it includes OSGi stuff
Patch1:        %{name}-manifest.patch

# Patch build.xml to patch modules as needed during javadoc generation
Patch2:        %{name}-modulefix.patch

BuildArch:     noarch

BuildRequires: javapackages-local
BuildRequires: ant
BuildRequires: apache-parent
BuildRequires: xalan-j2 >= 2.7.1
BuildRequires: xml-commons-apis >= 1.4.01
BuildRequires: xml-commons-resolver >= 1.2
BuildRequires: gnupg2

Requires:      xalan-j2 >= 2.7.1
Requires:      xml-commons-apis >= 1.4.01
Requires:      xml-commons-resolver >= 1.2
# Explicit javapackages-tools requires since scripts use
# /usr/share/java-utils/java-functions
Requires:      javapackages-tools

Provides:      jaxp_parser_impl = 1.4
Provides:      %{name}-scripts = %{version}-%{release}

Obsoletes:     %{name}-scripts < 2.11.0-6

# This documentation is provided by xml-commons-apis
Obsoletes:     %{name}-javadoc-apis < %{version}-%{release}

# http://mail-archives.apache.org/mod_mbox/xerces-j-dev/201008.mbox/%3COF8D7E2F83.0271A181-ON8525777F.00528302-8525777F.0054BBE0@ca.ibm.com%3E
Obsoletes:     %{name}-manual < %{version}-%{release}
Source44: import.info

%description
Welcome to the future! Xerces2 is the next generation of high performance,
fully compliant XML parsers in the Apache Xerces family. This new version of
Xerces introduces the Xerces Native Interface (XNI), a complete framework for
building parser components and configurations that is extremely modular and
easy to program.

The Apache Xerces2 parser is the reference implementation of XNI but other
parser components, configurations, and parsers can be written using the Xerces
Native Interface. For complete design and implementation documents, refer to
the XNI Manual.

Xerces2 is a fully conforming XML Schema processor. For more information,
refer to the XML Schema page.

Xerces2 also provides a complete implementation of the Document Object Model
Level 3 Core and Load/Save W3C Recommendations and provides a complete
implementation of the XML Inclusions (XInclude) W3C Recommendation. It also
provides support for OASIS XML Catalogs v1.1.

Xerces2 is able to parse documents written according to the XML 1.1
Recommendation, except that it does not yet provide an option to enable
normalization checking as described in section 2.13 of this specification. It
also handles name spaces according to the XML Namespaces 1.1 Recommendation,
and will correctly serialize XML 1.1 documents if the DOM level 3 load/save
APIs are in use.

%package        javadoc
Group: Development/Java
Summary:        Javadocs for %{name}

# Consolidating all javadocs into one package
Obsoletes:      %{name}-javadoc-impl < %{version}-%{release}
Obsoletes:      %{name}-javadoc-xs < %{version}-%{release}
Obsoletes:      %{name}-javadoc-xni < %{version}-%{release}
Obsoletes:      %{name}-javadoc-other < %{version}-%{release}
BuildArch: noarch

%description    javadoc
This package contains the API documentation for %{name}.

%package        demo
Group: Development/Other
Summary:        Demonstrations and samples for %{name}
Requires:       %{name} = %{?epoch:%epoch:}%{version}-%{release}

%description    demo
%{summary}.

%prep
# Verify the source file

%setup -q -n xerces-%{cvs_version}
%patch0
%patch1
%patch2


# Copy the custom ant task into place
mkdir -p tools/org/apache/xerces/util
mkdir -p tools/bin
cp -a %{SOURCE3} tools/org/apache/xerces/util

# Make sure upstream hasn't sneaked in any jars we don't know about
find . \( -name '*.class' -o -name '*.jar' \) -delete

sed -i 's/\r//' LICENSE README NOTICE

# Disable javadoc linting
sed -i -e "s|additionalparam='|additionalparam='-Xdoclint:none |" build.xml

# legacy aliases for compatability
%mvn_alias : xerces:xerces xerces:xmlParserAPIs apache:xerces-j2
%mvn_file : %{name} jaxp_parser_impl

%build
pushd tools

# Build custom ant tasks
javac -classpath $(build-classpath ant) org/apache/xerces/util/XJavac.java
jar cf bin/xjavac.jar org/apache/xerces/util/XJavac.class

ln -sf $(build-classpath xalan-j2-serializer) serializer.jar
ln -sf $(build-classpath xml-commons-apis) xml-apis.jar
ln -sf $(build-classpath xml-commons-resolver) resolver.jar
ln -sf $(build-classpath xerces-j2) x.jar
popd

# Build everything
export ANT_OPTS="-Xmx512m -Djava.awt.headless=true -Dbuild.sysclasspath=first -Ddisconnected=true"
ant -Djavac.source=1.7 -Djavac.target=1.7 \
    -Dbuild.compiler=modern \
    clean jars javadocs

%mvn_artifact %{SOURCE7} build/xercesImpl.jar

%install
%mvn_install

# javadoc
mkdir -p %{buildroot}%{_javadocdir}/%{name}
mkdir -p %{buildroot}%{_javadocdir}/%{name}/impl
mkdir -p %{buildroot}%{_javadocdir}/%{name}/xs
mkdir -p %{buildroot}%{_javadocdir}/%{name}/xni
mkdir -p %{buildroot}%{_javadocdir}/%{name}/other

cp -pr build/docs/javadocs/xerces2/* %{buildroot}%{_javadocdir}/%{name}/impl
cp -pr build/docs/javadocs/api/* %{buildroot}%{_javadocdir}/%{name}/xs
cp -pr build/docs/javadocs/xni/* %{buildroot}%{_javadocdir}/%{name}/xni
cp -pr build/docs/javadocs/other/* %{buildroot}%{_javadocdir}/%{name}/other

# scripts
%jpackage_script org.apache.xerces.impl.Version "" "" %{name} %{name}-version 1
%jpackage_script org.apache.xerces.impl.Constants "" "" %{name} %{name}-constants 1

# manual pages
install -d -m 755 %{buildroot}%{_mandir}/man1
install -p -m 644 %{SOURCE11} %{buildroot}%{_mandir}/man1
install -p -m 644 %{SOURCE12} %{buildroot}%{_mandir}/man1

# demo
install -pD -T build/xercesSamples.jar %{buildroot}%{_datadir}/%{name}/%{name}-samples.jar
cp -pr data %{buildroot}%{_datadir}/%{name}

%post
ln -sf %{name}.jar %{_javadir}/jaxp_parser_impl.jar

%files -f .mfiles
%doc LICENSE NOTICE README
%{_bindir}/*
%{_mandir}/*/*

%files javadoc
%{_javadocdir}/%{name}

%files demo
%{_datadir}/%{name}

%changelog
