Name: xfce4-pulseaudio-plugin
Version: 0.4.9
Release: alt1

Summary: A pulseaudio plugin for the Xfce panel
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/panel-plugins/xfce4-pulseaudio-plugin
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/panel-plugins/xfce4-pulseaudio-plugin.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%def_disable wnck
%def_enable libcanberra

%if_xfce4_wayland_support
%def_enable libxfce4windowing
%else
%def_disable libxfce4windowing
%endif

BuildRequires(pre): rpm-build-xfce4 >= 0.3.0 xfce4-dev-tools
BuildRequires: libxfce4panel-gtk3-devel libxfce4ui-gtk3-devel libxfce4util-devel
BuildRequires: libexo-gtk3-devel
BuildRequires: libxfconf-devel
BuildRequires: libpulseaudio-devel libnotify-devel
BuildRequires: libkeybinder3-devel
%{?_enable_wnck:BuildRequires: libwnck3-devel}
%{?_enable_libcanberra:BuildRequires: libcanberra-devel}
%{?_enable_libxfce4windowing:BuildRequires: libxfce4windowing-devel}

Requires: xfce4-panel >= 4.11

%define _unpackaged_files_terminate_build 1

%description
A panel plugin for controlling PulseAudio mixer.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--enable-maintainer-mode \
	--enable-keybinder \
	%{subst_enable wnck} \
	%{subst_enable libxfce4windowing} \
	%{subst_enable libcanberra} \
	--disable-silent-rules \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc README.md AUTHORS NEWS
%_libdir/xfce4/panel/plugins/*.so
%_datadir/xfce4/panel/plugins/*.desktop
%_iconsdir/hicolor/*/*/*.*

%exclude %_libdir/xfce4/panel/plugins/*.la

%changelog
