Name: xfce4-session
Version: 4.18.4
Release: alt1

Summary: Session manager for Xfce desktop environment
Summary (ru): Менеджер сессий для окружения рабочего стола Xfce
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/xfce/xfce4-session/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/xfce4-session.git
Source: %name-%version.tar
Source1: xfce.wmsession

Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfconf-devel libxfce4ui-gtk3-devel >= 4.18.2
# gdk-pixbuf-csource needed in maintainer mode
BuildRequires: libgdk-pixbuf-devel
BuildRequires: libpolkit-devel
BuildRequires: libdbus-glib-devel
BuildRequires: iceauth intltool libSM-devel libwnck3-devel xorg-cf-files

Requires: wm-common-freedesktop
Requires: xfce4-about

Obsoletes: xfce-utils < %version
Obsoletes: libxfsm < %version-%release

Conflicts: xfce4-screensaver < 0.1.10-alt1

%define _unpackaged_files_terminate_build 1

%description
%name is the session manager for the Xfce desktop environment.

%description -l ru
Данный пакет содержит в себе менеджер сессий, используемый в окружении
рабочего стола Xfce.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--with-backend=linux \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
install -Dm0644 %SOURCE1 %buildroot%_x11sysconfdir/wmsession.d/10Xfce4
%find_lang %name

%files -f %name.lang
%doc README.md NEWS AUTHORS
%doc doc/FAQ doc/README.Kiosk
%_x11sysconfdir/wmsession.d/*
%config(noreplace) %_sysconfdir/xdg/xfce4/*
%config(noreplace) %_sysconfdir/xdg/autostart/*.desktop
%_sysconfdir/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-session.xml
%_bindir/*
%dir %_libdir/xfce4/session
%_libdir/xfce4/session/xfsm-*
%_desktopdir/*
%_iconsdir/hicolor/*/*/*
%_mandir/man?/*
%_datadir/xsessions/*.desktop
%_datadir/polkit-1/actions/*.policy
%_datadir/xdg-desktop-portal/xfce-portals.conf

%changelog
