Name: xfce4-terminal
Version: 1.1.5
Release: alt1

Summary: Terminal emulator application for Xfce
Summary (ru_RU.UTF-8): Эмулятор терминала для Xfce
License: GPLv2+
Group: Terminals
Url: https://docs.xfce.org/apps/terminal/start
Packager: Xfce Team <xfce@packages.altlinux.org>
Vcs: https://gitlab.xfce.org/apps/xfce4-terminal.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%if_xfce4_wayland_support
%def_enable wayland
%else
%def_disable wayland
%endif

BuildRequires(pre): rpm-build-xfce4 >= 0.3.0 xfce4-dev-tools >= 4.18.1
BuildRequires: libxfce4util >= 4.16.0 libxfconf-devel >= 4.16.0 libxfce4ui-gtk3-devel >= 4.17.5
BuildRequires: libpcre2-devel
BuildRequires: docbook-dtds docbook-style-xsl libvte3-devel
%{?_enable_wayland:Buildrequires: libgtk-layer-shell-devel}
BuildRequires: xsltproc

Requires: xfce4-common

Obsoletes: Terminal < %version
Provides: Terminal = %version-%release

Provides: x-terminal-emulator

%define _unpackaged_files_terminate_build 1

%description
This is the xfce4-terminal emulator application. xfce4-terminal is
a lightweight and easy to use terminal emulator for X windowing system
with some new ideas and features that makes it unique among X terminal
emulators.

%description -l ru_RU.UTF-8
xfce4-terminal - легкий и удобный эмулятор терминала для Xfce.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--enable-maintainer-mode \
	--enable-x11 \
	%{subst_enable wayland} \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

mkdir -p %buildroot%_altdir
cat << __EOF__ > %buildroot%_altdir/%name
%_bindir/x-terminal-emulator	%_bindir/%name	42
__EOF__

%files -f %name.lang
%doc README.md NEWS THANKS
%_bindir/*
%_altdir/%name
%_man1dir/*
%_datadir/xfce4/terminal
%_iconsdir/hicolor/*/apps/*
%_desktopdir/*

%changelog
