Name: xlockmore
Version: 5.66
Release: alt1

Summary: An X terminal locking program
License: MIT
Group: Graphical desktop/Other
Url: http://sillycycle.com/xlockmore.html

Source: %name-%version.tar.xz
Source1: icons.tar.gz
Source2: pam.d.tar
Source3: po.tar.gz

Patch0001: 0001-Fix-install-modes.patch
Patch0002: 0002-Use-PAM-for-authorization.patch
Patch0003: 0003-Localize-and-translate.patch
Patch0004: 0004-Use-KBD-monitoring.patch
Patch0005: 0005-Provide-nologout-option-for-user-switching.patch
Patch0006: 0006-Use-Droid-fonts-instead-of-legacy-ones.patch
Patch0007: 0007-Switch-from-_BSD_SOURCE-to-_DEFAULT_SOURCE.patch
Patch0008: 0008-Fix-freetype2-detection.patch

PreReq: /etc/tcb
Requires: fortune-mod
Requires: fonts-ttf-google-droid-sans fonts-ttf-google-droid-sans-mono fonts-ttf-google-droid-serif

BuildPreReq: gcc-c++
# Automatically added by buildreq on Sun Jun 29 2014
# optimized out: gnu-config libGL-devel libGLU-devel libICE-devel libSM-devel libX11-devel libXt-devel libcloog-isl4 libfreetype-devel libstdc++-devel pkg-config xorg-kbproto-devel xorg-xextproto-devel xorg-xproto-devel
BuildRequires: gcc-c++ imake libXdmcp-devel libXext-devel libXinerama-devel libXmu-devel libXpm-devel libftgl-devel libpam-devel xorg-cf-files autoconf-archive

%description
The %name utility is an enhanced version of the standard xlock
program, which allows you to lock an X session so that other users
can't access it. Xlockmore runs a provided screensaver until you type
in your password.

Install the %name package if you need a locking program to secure
X sessions.

%prep
%setup -a1 -a2 -a3
%patch0001 -p2
#patch0002 -p2
%patch0003 -p2
%patch0004 -p2
%patch0005 -p2
%patch0006 -p2
#patch0007 -p2
%patch0008 -p2

# XXX hack out boxed moide than hangs
sed -i 's/#define MODE_boxed/#undef MODE_boxed/' xlock/mode.h

%build
cp /usr/share/aclocal/ax_pthread.m4 .
autoconf
ftgl_includes=%_includedir/FTGL %configure \
	--without-motif \
	--without-gtk \
	--without-esound \
	--disable-def-play \
	--enable-pam \
	--enable-bad-pam \
	--enable-vtlock \
	--enable-button-logout=85 \
	--enable-kbdmon
# Hack a little
echo '#define FTGL213' >> config.h

%make_build \
	xapploaddir=%_sysconfdir/X11/app-defaults

%install
install -p -m640 -D pam.d/xlock %buildroot%_sysconfdir/pam.d/xlock
install -p -m644 -D xlock/xlock.man %buildroot%_mandir/man1/xlock.1
install -p -m644 -D xlock/XLock.ad %buildroot%_sysconfdir/X11/app-defaults/XLock
install -p -m644 -D xlock/XLock-ja.ad %buildroot%_sysconfdir/X11/app-defaults/XLock.ja_JP.EUCJP
install -p -m644 -D xlock/XLock-zh_TW.ad %buildroot%_sysconfdir/X11/app-defaults/XLock.zh_TW.UTF-8
install -p -m644 -D xlock/XLock-ru.ad %buildroot%_sysconfdir/X11/app-defaults/XLock.ru_RU.UTF-8

install -D -m 644 icons/xlock-16x16.xpm %buildroot%_miconsdir/%name.xpm
install -D -m 644 icons/xlock-32x32.xpm %buildroot%_iconsdir/%name.xpm
install -D -m 644 icons/xlock-48x48.xpm %buildroot%_liconsdir/%name.xpm

%make_install install \
	prefix=%buildroot%prefix \
	bindir=%buildroot%_bindir \
	mandir=%buildroot%_mandir \
	datadir=%buildroot%_datadir \
	xapploaddir=%buildroot%_sysconfdir/X11/app-defaults

chmod 755 %buildroot%_bindir/*
install -d %buildroot%_datadir/xlock/fonts

%post
find %_datadir/fonts/ttf -type f -iname \*.ttf | xargs -I. ln -sf . %_datadir/xlock/fonts/

%postun
rm -rf %_datadir/xlock/fonts/

%files
%config(noreplace) %_sysconfdir/X11/app-defaults/*
%attr(2711,root,chkpwd) %_bindir/*
%attr(0640,root,chkpwd) %config(noreplace) %_sysconfdir/pam.d/*
%_mandir/man?/*
%_iconsdir/%name.xpm
%_miconsdir/%name.xpm
%_liconsdir/%name.xpm
%_datadir/locale/*/*/xlock.mo
%_datadir/xlock
%exclude %_mandir/xlock.1*

%changelog
