# disable LTO to avoid build failures:
# https://gitlab.freedesktop.org/xorg/xserver/-/issues/1060
%define optflags_lto %nil

%define mesaversion 19.0
%define xorgversion 7.7.0

%define _libexecdir /usr/libexec
%define _modulesdir %_libdir/X11/modules
%define _fontsdir %_datadir/fonts
%define _deffontdir catalogue:%_sysconfdir/X11/fontpath.d

%def_enable glamor
%def_disable xwayland

%def_enable dmx
%def_enable xnest
%def_enable ipv6

%def_enable xephyr
%if_enabled xephyr
%def_enable kdrive
%else
%def_disable kdrive
%endif

%def_enable systemd

Name: xorg-server
Version: 1.20.14
Release: alt18
Epoch: 2
License: MIT/X11
Summary: Xserver - X Window System display server
Group: System/X11
Url: http://xorg.freedesktop.org
Packager: Valery Inozemtsev <shrek@altlinux.ru>

# grep ABI_ hw/xfree86/common/xf86Module.h
Provides: XORG_ABI_VIDEODRV = 24.1
Provides: XORG_ABI_XINPUT = 24.1
Provides: XORG_ABI_EXTENSION = 10.0
Provides: xorg-x11-server = %epoch:%version-%release xorg-extensions-glx = %epoch:%version-%release
%if_enabled glamor
Provides: xorg-glamor = %epoch:%version-%release
Obsoletes: xorg-glamor < %epoch:%version-%release
%endif
PreReq: xorg-server-control >= 1.3-alt1 %name-common = %epoch:%version-%release xorg-dri-swrast >= %mesaversion
Requires: xset iceauth xdpyinfo xorg-drv-fbdev xorg-drv-evdev
%ifarch %ix86 x86_64
Requires: xorg-drv-vesa
%endif
Provides: xorg-drv-modesetting = %epoch:%version-%release
Obsoletes: xorg-drv-modesetting < %epoch:%version-%release

Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch2: alt-drop-cvt.diff

BuildRequires: doxygen flex libGL-devel libXau-devel libXaw-devel libXdmcp-devel libXext-devel libXfixes-devel libXfont-devel libXmu-devel
BuildRequires: libXi-devel libXpm-devel libXrender-devel libXres-devel libXtst-devel libXv-devel libdmx-devel libudev-devel libSM-devel
BuildRequires: libpciaccess-devel libpixman-devel libssl-devel libxkbfile-devel xorg-proto-devel xorg-font-utils xorg-xtrans-devel xkbcomp
BuildRequires: xorg-util-macros libselinux-devel libaudit-devel xmlto xorg-sgml-doctools libxshmfence-devel libdrm-devel libXfont2-devel
%if_enabled glamor
BuildRequires: libEGL-devel libgbm-devel libepoxy-devel
%endif
%if_enabled xwayland
BuildRequires: libwayland-client-devel wayland-protocols
%endif
%if_enabled xephyr
BuildRequires: libxcbutil-devel libxcbutil-image-devel libxcbutil-icccm-devel libxcbutil-keysyms-devel libxcb-render-util-devel
%endif
%{?_enable_systemd:BuildRequires: libdbus-devel libudev-devel}

%description
X  is  the  generic name for the X Window System display server.  It is
frequently a link or a copy of the appropriate server binary for  driving
the most frequently used server on a given machine.

%package common
Summary: The X server common files
Group: System/X11
Requires: xorg-rgb xauth fonts-bitmap-misc >= 7.0.0-alt2
Requires: xkbcomp xkeyboard-config
Obsoletes: libXiconfig

%description common
%name-common is common files for X.Org

%package -n xorg-xvfb
Summary: A virtual framebuffer X Windows System server for X.Org
Group: System/X11
Requires: %name-common = %epoch:%version-%release xorg-dri-swrast >= %mesaversion
Provides: xorg-x11-xvfb = %epoch:%version-%release

%description -n xorg-xvfb
Xvfb (X Virtual Frame Buffer) is an X Windows System server
that is capable of running on machines with no display hardware and no
physical input devices.  Xvfb emulates a dumb framebuffer using virtual
memory.  Xvfb doesn't open any devices, but behaves otherwise as an X
display.  Xvfb is normally used for testing servers.  Using Xvfb, the mfb
or cfb code for any depth can be exercised without using real hardware
that supports the desired depths.  Xvfb has also been used to test X
clients against unusual depths and screen configurations, to do batch
processing with Xvfb as a background rendering engine, to do load testing,
to help with porting an X server to a new platform, and to provide an
unobtrusive way of running applications which really don't need an X
server but insist on having one.

If you need to test your X server or your X clients, you may want to
install Xvfb for that purpose.

%package -n xorg-xnest
Summary: A nested X.Org server
Group: System/X11
Requires: %name-common = %epoch:%version-%release xorg-dri-swrast >= %mesaversion
Provides: xorg-x11-xnest = %epoch:%version-%release

%description -n xorg-xnest
Xnest is an X Window System server which runs in an X window.
Xnest is a 'nested' window server, actually a client of the
real X server, which manages windows and graphics requests
for Xnest, while Xnest manages the windows and graphics
requests for its own clients.

You will need to install Xnest if you require an X server which
will run as a client of your real X server (perhaps for
testing purposes).

%package -n xorg-xephyr
Summary: A kdrive-based X server
Group: System/X11
Requires: %name = %epoch:%version-%release

%description -n xorg-xephyr
Xephyr is a kdrive based X Server which targets a window on
a host X Server as its framebuffer. Unlike Xnest it supports
modern X extensions (even if host server doesn't) such as Composite,
Damage, randr etc.

It uses SHM Images and shadow framebuffer updates to provide
good performance.
It also has a visual debugging mode for observing screen updates.

%package -n xorg-xdmx
Summary: Multi-head X server
Group: System/X11
Requires: %name = %epoch:%version-%release

%description -n xorg-xdmx
Xdmx  is  a proxy X server that uses one or more other X servers as its
display devices.  It provides multi-head X functionality  for  displays
that  might  be  located  on  different  machines.  Xdmx functions as a
front-end X server that acts as a proxy to a set of back-end X servers.
All  of  the  visible  rendering  is  passed to the back-end X servers.
Clients connect to the Xdmx front-end, and  everything  appears  as  it
would  in  a  regular multi-head configuration.  If Xinerama is enabled
(e.g., with +xinerama on the command line), the clients  see  a  single
large screen.

Xdmx communicates to the back-end X servers using the standard X11 pro-
tocol, and standard and/or commonly available X server extensions.

%package -n xorg-xwayland
Summary: Wayland X server
Group: System/X11
Requires: %name = %epoch:%version-%release

%description -n xorg-xwayland
Xwayland is an X server for running X clients under Wayland

%package -n xorg-sdk
Summary: SDK for X server driver module development
Group: Development/C
Requires: xorg-util-macros xorg-dri3proto-devel xorg-presentproto-devel
%if_enabled glamor
Provides: xorg-glamor-devel = %epoch:%version-%release
Obsoletes: xorg-glamor-devel < %epoch:%version-%release
%endif

%description -n xorg-sdk
The SDK package provides the developmental files which are necessary for
developing X server driver modules, and for compiling driver modules
outside of the standard X11 source code tree.  Developers writing video
drivers, input drivers, or other X modules should install this package.

%prep
%setup -q
%patch -p1
%patch2 -p1

%build
%autoreconf
%configure \
	--with-os-name="%(cat %_sysconfdir/altlinux-release)" \
	--with-os-vendor="%(uname -m)" \
	--with-builder-addr="%packager" \
	--with-serverconfig-path=%_datadir/X11 \
	--with-module-dir=%_modulesdir \
	--with-log-dir=%_logdir \
	--with-xkb-path=%_datadir/X11/xkb \
	--with-xkb-output=%_localstatedir/xkb \
	--with-default-font-path=%_deffontdir \
	--with-shared-memory-dir=/dev/shm \
%ifarch %ix86 x86_64
	--with-int10=x86emu \
%endif
	--enable-xcsecurity \
	--enable-xselinux \
	--enable-config-udev \
	--disable-config-hal \
	--disable-linux-apm \
	--disable-linux-acpi \
	--enable-record \
	%{subst_enable xwayland} \
	%{subst_enable glamor} \
	%{subst_enable dmx} \
	%{subst_enable xnest} \
	%{subst_enable xephyr} \
	%{subst_enable kdrive} \
	%{subst_enable ipv6} \
	--enable-docs \
	--disable-static \
	%{?_enable_systemd:--enable-systemd-logind}
%make_build

%install
%make DESTDIR=%buildroot install

find %buildroot%_modulesdir -name \*.la -delete

mkdir -p %buildroot%_modulesdir/{drivers,input}
mkdir -p %buildroot%_datadir/X11
mkdir -p %buildroot%_sysconfdir/X11/{app-defaults,xorg.conf.d}

touch %buildroot%_sysconfdir/X11/xorg.conf

install -pD -m644 xserver.pamd %buildroot%_sysconfdir/pam.d/xserver
mkdir -p %buildroot%_sysconfdir/security/console.apps
touch %buildroot%_sysconfdir/security/console.apps/xserver

# rpm macros
install -pD -m644 xorg-sdk.rpmmacros %buildroot%_rpmmacrosdir/xorg-sdk

%pre
%_sbindir/groupadd -r -f xgrp
%pre_control xorg-server

%post
%post_control xorg-server

%files
%config(noreplace) %_sysconfdir/pam.d/xserver
%config(missingok noreplace) %_sysconfdir/security/console.apps/xserver
%ghost %_sysconfdir/X11/xorg.conf
%_bindir/X
%attr(0700,root,root) %_bindir/Xorg
%_bindir/gtf
%dir %_modulesdir/drivers
%dir %_modulesdir/input
%dir %_modulesdir/extensions
%_modulesdir/extensions/libglx.so
%_modulesdir/*.so
%_man1dir/Xorg.1*
%_man1dir/gtf.1*
%_man1dir/Xserver.1*
%_man4dir/fbdevhw.4*
%_man4dir/exa.4*
%_man5dir/xorg.conf.5*
%_man5dir/xorg.conf.d.5*
%_modulesdir/drivers/modesetting_drv.so
%_man4dir/modesetting.4*

%files common
%dir %_sysconfdir/X11/app-defaults
%dir %_sysconfdir/X11/xorg.conf.d
%dir %_libdir/X11
%dir %_datadir/X11
%_datadir/X11/xorg.conf.d
%_datadir/X11/protocol.txt
%dir %_modulesdir
%_localstatedir/xkb

%files -n xorg-xvfb
%_bindir/Xvfb
%_man1dir/Xvfb.1*

%if_enabled xnest
%files -n xorg-xnest
%_bindir/Xnest
%_man1dir/Xnest.1*
%endif

%if_enabled xephyr
%files -n xorg-xephyr
%_bindir/Xephyr
%_man1dir/Xephyr.1*
%endif

%if_enabled dmx
%files -n xorg-xdmx
%_bindir/*dmx*
%_man1dir/*dmx*.1*
%endif

%if_enabled xwayland
%files -n xorg-xwayland
%_bindir/Xwayland
%endif

%files -n xorg-sdk
%_includedir/xorg
%_pkgconfigdir/*.pc
%_datadir/aclocal/*.m4
%_rpmmacrosdir/xorg-sdk

%changelog
