%global _unpackaged_files_terminate_build 1
Name: 	 xrdp
Version: 0.10.2
Release: alt2

Summary: An open source remote desktop protocol (RDP) server

License: GPLv2+ with exceptions and Apache-2.0
Group: 	 System/Servers
Url: 	 http://xrdp.sourceforge.net/

Packager: Andrey Cherepanov <cas@altlinux.org>

Source:  %name-%version.tar
# VCS:   https://github.com/neutrinolabs/xrdp
Source1: %name.sysconfig
Source2: %name.logrotate
Source3: %name-init-alt
Source4: submodules.tar
Source6: xorgxrdp.tar
Source7: xrdp-sesman.pam
Source8: xrdp-polkit-1.rules

# patches from Debian
Patch2: asm-xorgxrdp.diff
Patch3: make-fixes.diff
Patch5: misc-fixes.diff
Patch10: lfs.diff

# Other patches
Patch12: xrdp-alt-startwm.patch
Patch13: alt-add-russian-keyboard.patch
Patch14: xrdp-alt-add-comment-about-windows_xp.patch
Patch15: xrdp-alt-default-gxf-order.patch
Patch16: xrdp-alt-ppc64le-support.patch

# Fedora patches
Patch21: xrdp-service.patch
Patch22: xrdp-0.9.6-script-interpreter.patch
Patch23: xrdp-0.9.9-sesman.patch
Patch24: xrdp-0.9.10-scripts-libexec.patch
Patch25: xrdp-0.9.14-arch.patch
Patch28: xrdp-0.9.14-vnc-uninit.patch
Patch30: xrdp-0.9.14-xrdp-ini.patch
Patch31: xrdp-0.9.15-g_check_user_in_group.patch

BuildPreReq: rpm-build-intro rpm-macros-intro-conflicts
BuildRequires: libjpeg-devel
BuildRequires: libturbojpeg-devel
BuildRequires: libpam-devel
BuildRequires: libssl-devel
BuildRequires: libX11-devel
BuildRequires: libXfixes-devel
BuildRequires: libXrandr-devel
BuildRequires: xorg-resourceproto-devel
BuildRequires: xorg-scrnsaverproto-devel
BuildRequires: libXfont2-devel
BuildRequires: libfuse3-devel
BuildRequires: libfreerdp-devel
BuildRequires: libopus-devel
BuildRequires: openssl
BuildRequires: xorg-sdk
BuildRequires: nasm
# For glamor support
BuildRequires: libgbm-devel
BuildRequires: libepoxy-devel
BuildRequires: libdrm-devel
BuildRequires: imlib2-devel
BuildRequires: libfreetype-devel
BuildRequires: libpixman-devel
BuildRequires: fdkaac
BuildRequires: liblame-devel
BuildRequires: libfdk-aac-devel
BuildRequires: libx264-devel
BuildRequires: libopenh264-devel

Requires: xorg-drv-xrdp = %EVR
Requires: xinitrc

Provides: librfxcodec = %EVR
Obsoletes: librfxcodec < %EVR
Provides: librfxcodec-devel = %EVR
Obsoletes: librfxcodec-devel < %EVR

%filter_from_requires \,^/etc/X11/xinit/Xsession,d
%filter_from_requires \,^/usr/etc/X11/xdm/Xsession,d
%filter_from_requires \,^/etc/X11/xdm/Xsession,d
%filter_from_requires \,^/etc/X11/xinit/xinitrc,d
%filter_from_requires \,^/etc/sysconfig/i18n,d

%description
xrdp offers a graphical login to a remote client using
RDP (the Remote Desktop Protocol). xrdp can connect to
a locally created X.org session with the xorgxrdp drivers,
to a VNC X11 server, and forward to another RDP server.

xrdp accepts connections from freerdp, rdesktop, and the
built-in terminal server / remote desktop clients of
Microsoft Windows operating systems.
In the xorgxrdp (which replaces X11RDP) and VNC modes,
it provides a fully functional Linux terminal server,
offering an X-Window desktop to the user. In the RDP
or VNC forwarding mode, any sort of desktop can be used.

%package -n xorg-drv-%name
Summary: Remote Desktop Protocol (RDP) modules for X.org
Group: System/X11
Provides: xorgxrdp = %EVR

%description -n xorg-drv-xrdp
xorgxrdp is a set of drivers (screen device, keyboard, and mouse)
for X.org enabling use through an RDP session with xrdp. For full
operation, most standard X11 fonts and tools need to be installed.

%prep
%setup
tar xf %SOURCE4
tar xf %SOURCE6
#patch2 -p1
%patch3 -p1
%patch5 -p1
%patch10 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch21 -p1
%patch22 -p1
%patch25 -p1
%patch28 -p1
%patch31 -p1
%ifarch %e2k
sed -i 's/-Werror/-Wno-error/g' configure.ac
%endif

cp %SOURCE3 %name-init

subst "s|/usr/lib|%_libdir|g" %name-init
find . -type f -name Makefile.am -exec subst "s|\${localstatedir}\/run|/var/run|g" {} \;

# remove unused modules from xrdp login combobox
subst '/^\[Xvnc\]/,$s/^\([a-z[]\)/#\1/' xrdp/xrdp.ini.in

# create 'bash -l' based startwm, to pick up PATH etc.
echo '#!/bin/bash -l
. %_sysconfdir/xrdp/startwm.sh' > sesman/startwm-bash.sh

%build
%add_optflags -I%_includedir/libdrm
%add_optflags -Wno-error=int-to-pointer-cast
%ifarch %ix86 armh
%add_optflags -D_FILE_OFFSET_BITS=64
%endif
%ifarch %ix86
%add_optflags -fPIC
%set_verify_elf_method textrel=relaxed
%endif
./bootstrap
for dir in xorgxrdp librfxcodec libpainter; do
	pushd $dir
	./bootstrap
	popd
done
#autoreconf
%configure \ #--disable-static \
	   --enable-jpeg \
	   --enable-fuse \
	   --enable-rfxcodec \
	   --enable-opus \
	   --enable-painter \
	   --enable-pixman \
	   --with-imlib2=yes \
	   --enable-tjpeg \
	   --with-freetype2=yes \
	   --enable-mp3lame \
	   --enable-vsock \
	   --enable-rdpsndaudin \
	   --enable-fdkaac \
	   --enable-strict-locations \
	   --enable-x264 \
	   --enable-openh264 \
	   --with-systemdsystemunitdir=%_unitdir
pushd xorgxrdp
PKG_CONFIG_PATH=../pkgconfig ./configure --enable-glamor
popd
pushd librfxcodec
./configure \
	    --disable-shared \
	    --enable-static
popd
pushd libpainter
./configure \
	    --disable-shared \
	    --enable-static
popd
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_sysconfdir/xrdp

rm -f %buildroot/%_libdir/xrdp/startwm.sh
rm -f %buildroot/%_libdir/xrdp/xrdp_control.sh
install -D -m755 %name-init %buildroot%_initdir/%name
rm -rf %buildroot%_sysconfdir/init.d

# install sesman pam config 
install -Dp -m 644 %SOURCE7 %buildroot%_sysconfdir/pam.d/xrdp-sesman

# install xrdp systemd units
install -Dp -m 644 instfiles/xrdp.service %buildroot%_unitdir/xrdp.service
install -Dp -m 644 instfiles/xrdp-sesman.service %buildroot%_unitdir/xrdp-sesman.service

# install xrdp sysconfig /etc/sysconfig/xrdp
install -Dp -m 644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/xrdp

# install logrotate /etc/logrotate.d/xrdp
install -Dp -m 644 %SOURCE2 %buildroot%_logrotatedir/%name

# install log file /var/log/xrdp-sesman.log
mkdir -p %buildroot%_logdir
touch %buildroot%_logdir/xrdp-sesman.log

# rsakeys.ini
touch %buildroot%_sysconfdir/xrdp/rsakeys.ini
chmod 0600 %buildroot%_sysconfdir/xrdp/rsakeys.ini

# install 'bash -l' startwm script
install -Dp -m 755 sesman/startwm-bash.sh %buildroot%_sysconfdir/xrdp/startwm-bash.sh

# install openssl config for key generation
install -Dp -m 644 keygen/openssl.conf %buildroot%_sysconfdir/xrdp/openssl.conf

#install xrdp.rules /usr/share/polkit-1/rules.d
install -Dp -m 644 %SOURCE8 %buildroot%_datadir/polkit-1/rules.d/xrdp.rules

# Clean unnecessary files
find %buildroot -name *.a -delete -o -name *.la -delete
rm -rf %buildroot{/usr/local,%_includedir,%_pkgconfigdir}

%pre
groupadd -r -f tsusers 2>/dev/null ||:
groupadd -r -f tsadmins 2>/dev/null ||:

%post
# Generate keys if they are missing
if [ ! -s %_sysconfdir/xrdp/rsakeys.ini ]; then
  (umask 377; %_bindir/xrdp-keygen xrdp %_sysconfdir/xrdp/rsakeys.ini >/dev/null)
  chmod 400 %_sysconfdir/xrdp/rsakeys.ini
fi

if [ ! -s %_sysconfdir/xrdp/cert.pem ]; then
  (umask 377; openssl req -x509 -newkey rsa:2048 -sha256 -nodes -days 3652 \
    -keyout %_sysconfdir/xrdp/key.pem \
    -out %_sysconfdir/xrdp/cert.pem \
    -subj /C=US/ST=CA/L=Sunnyvale/O=xrdp/CN=www.xrdp.org \
    -config %_sysconfdir/xrdp/openssl.conf >/dev/null 2>&1)
  chmod 400 %_sysconfdir/xrdp/cert.pem
  chmod 400 %_sysconfdir/xrdp/key.pem
fi
%post_service %{name}-sesman
%post_service %name

%preun
%preun_service %name
%preun_service %{name}-sesman

%files
%config(noreplace) %_sysconfdir/pam.d/xrdp-sesman
%dir %_sysconfdir/xrdp
%_sysconfdir/xrdp/km*.ini
%_sysconfdir/xrdp/*.sh
%dir %_sysconfdir/xrdp/pulse
%_sysconfdir/xrdp/pulse/default.pa
%_sysconfdir/xrdp/xrdp_keyboard.ini
%_sysconfdir/xrdp/openssl.conf
%_initdir/%name
%config(noreplace) %_sysconfdir/sysconfig/xrdp
%_unitdir/*.service
%ghost %_logdir/xrdp-sesman.log
%ghost %config(noreplace) %attr(0400,root,root) %verify(not size md5 mtime) %_sysconfdir/xrdp/rsakeys.ini
%ghost %config(noreplace) %attr(0400,root,root) %verify(not size md5 mtime) %_sysconfdir/xrdp/*.pem
%config(noreplace) %_sysconfdir/xrdp/sesman.ini
%config(noreplace) %_sysconfdir/xrdp/xrdp.ini
%config(noreplace) %_sysconfdir/xrdp/gfx.toml
%_bindir/xrdp*
%_libexecdir/xrdp/*
%_sbindir/xrdp*
%_libdir/%name
%_logrotatedir/%name
%dir %_datadir/xrdp
%_datadir/xrdp/*
%_datadir/polkit-1/rules.d/xrdp.rules
%_man1dir/*
%_man5dir/*
%_man8dir/*

%files -n xorg-drv-xrdp
%_sysconfdir/X11/%name/xorg.conf
%_x11modulesdir/*.so
%_x11modulesdir/drivers/*.so
%_x11modulesdir/input/*.so

%changelog
