Name: xviewer
Version: 3.2.12
Release: alt1

Summary: Fast and functional image viewer.
License: %gpl2plus
Group: Graphics
Url: https://github.com/linuxmint/xviewer

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-gnome rpm-build-licenses

# From configure.in
BuildRequires: gnome-common intltool yelp-tools
BuildRequires: gtk-doc
BuildPreReq: libgtk+3-devel >= 3.14.0
BuildPreReq: libgio-devel >= 2.38.0
BuildPreReq: libcinnamon-desktop-devel >= 3.8.0
BuildPreReq: gnome-icon-theme >= 2.19.1
BuildPreReq: shared-mime-info >= 0.60
BuildPreReq: libexempi-devel >= 1.99.5
BuildPreReq: libexif-devel >= 0.6.14
%{?_enable_color_management:BuildPreReq: liblcms2-devel}
BuildPreReq: libjpeg-devel librsvg-devel
BuildPreReq: libpeas-devel >= 0.7.4
BuildRequires: libXt-devel libxml2-devel perl-XML-Parser zlib-devel gsettings-desktop-schemas-devel
BuildPreReq: gobject-introspection-devel >= 0.10.2 libgtk+3-gir-devel
BuildRequires: libxapps-devel
BuildRequires: meson

Requires: xapps-icons

%description
This is Xviewer, a fast and functional image viewer.

%package devel
Summary: Development files for Xviewer viewer
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
This package contains files necessary to develop plugins for Xviewer.

%package gir
Summary: GObject introspection data for the Xviewer
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Xviewer

%package tests
Summary: Tests for the Xviewer
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the Xviewer GUI.


%prep
%setup
%autopatch -p1

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%_datadir/%name/
%dir %_libdir/%name
%_libdir/%name/lib%name.so
%_iconsdir/hicolor/*/apps/%{name}*.*
%config %_datadir/glib-2.0/schemas/org.x.viewer.enums.xml
%config %_datadir/glib-2.0/schemas/org.x.viewer.gschema.xml
%_datadir/metainfo/%name.appdata.xml
%_datadir/gtk-doc/html/%name
%doc AUTHORS MAINTAINERS
%doc README.md THANKS

%files devel
%dir %_includedir/%name
%_includedir/%name/*.h
%_pkgconfigdir/%name.pc

%files gir
%_libdir/%name/girepository-1.0/*.typelib

%changelog
