Name: xz
Version: 5.4.5
Release: alt1

Summary: LZMA/XZ compression programs
# We don't package scripts to grep, diff, and view compressed files here
# because they are already packaged in gzip-utils.
# see COPYING
License: ALT-Public-Domain
Group: Archiving/Compression
URL: http://tukaani.org/xz/
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: liblzma = %version-%release

# Last lzma-utils version was 4.32.7
Provides: lzma-utils = 4.32.9
Obsoletes: lzma-utils < 4.32.9

# Automatically added by buildreq on Fri Jul 20 2012
# optimized out: xz
BuildRequires: glibc-devel-static

%description
This package provides a set of gzip-style tools for working with
files compressed with the Lempel-Ziv/Markov-chain compression method.
It supports two formats: .xz and the older .lzma format.

%package -n liblzma
Summary: LZMA/XZ compression library
Group: System/Libraries

%package -n liblzma-devel
Summary: API headers and other development files related to liblzma
Group: Development/C
Requires: liblzma = %version-%release
Conflicts: lzmalib-devel

%package -n liblzma-devel-static
Summary: Static liblzma compression library
Group: Development/C
Requires: liblzma-devel = %version-%release

%description -n liblzma
This package provides data compression library for working with
files compressed with the Lempel-Ziv/Markov-chain compression method.
It supports two formats: .xz and the older .lzma format.

%description -n liblzma-devel
This package contains the API headers, development library, and
other development files related to liblzma

%description -n liblzma-devel-static
This package contains static liblzma compression library.

%prep
%setup -q
%patch -p1
%ifarch e2kv5 e2kv6
# 15%% faster lzma decompression (idea by Alexander Troosh from MCST)
sed -i -E 's/rc_bound = (.*) [*] (.*);/rc_bound = __builtin_e2k_pmullw(\1,\2);/' \
	src/liblzma/rangecoder/range_decoder.h
%endif

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%ifarch %ix86
# liblzma uses crc*_x86.S asm code on i686
%add_optflags -Wa,--generate-missing-build-notes=yes
%endif

%autoreconf
%define docdir %_docdir/%name-%version
%configure --enable-dynamic --disable-scripts --docdir=%docdir
cflags=$(sed -n 's/^CFLAGS = //p' src/liblzma/Makefile)
%make_build -C src/liblzma CFLAGS="${cflags:?} %{!?_enable_debug:-O3}" liblzma_la-lzma_decoder.lo
%make_build

%def_enable profile
%if_enabled profile
# 5-10%% faster on x86_64
# 15%% faster compression and 40%% faster decompression on e2k
tar cf .tar */*/*.o */*.[ch] */*/*.[ch] */*/*/*.[ch] */*/*/*/*.[ch] \
	*/*.txt tests/files */*/.libs/*.{o,so*} --sort=name --mtime=@2718281828
stat --printf=".tar size: %%s\n" .tar
md5sum .tar
rm src/liblzma/{*.lo,liblzma.la}
%make_build -C src/liblzma CFLAGS="$cflags -fprofile-generate %{!?_enable_debug:-O3}" liblzma_la-lzma_decoder.lo
%make_build -C src/liblzma CFLAGS="$cflags -fprofile-generate"
./libtool --tag=CC --mode=link gcc %optflags -fprofile-generate -static src/xz/xz-*.o src/liblzma/liblzma.la -o xz.static
# ./xz.static collect profiles from src/liblzma/*.o
# ./src/xz/xz collect profiles from src/liblzma/.libs/*.o compiled with -fPIC -DPIC
# doesn't matter which to use for LCC 1.25 on E2K
for i in '0 -C none' '2 -C crc32' '6 --arm --lzma2 -C crc64' '6 --x86 --lzma2=lc=4 -C sha256' '7e --format=lzma'; do
	# .tmp needed to workaround LCC bug with corrupted profile written by several apps concurrently
	./src/xz/xz -$i <.tar >.tmp ; ./xz.static -d <.tmp >/dev/null
	./xz.static -$i <.tar >.tmp ; ./src/xz/xz -d <.tmp >/dev/null
done
rm src/liblzma/{*.lo,liblzma.la} .tmp xz.static
%ifarch %e2k
eprof_helper
# lcc needs special paths handling, MCST is not willing to fix this
%define profile_file '=../../eprof.sum'
%else
%define profile_file %nil
%endif
%make_build -C src/liblzma CFLAGS="$cflags -fprofile-use%profile_file %{!?_enable_debug:-O3}" liblzma_la-lzma_decoder.lo
%make_build -C src/liblzma CFLAGS="$cflags -fprofile-use%profile_file"
%make_build
readelf -n src/liblzma/.libs/*.so
%endif

%install
%makeinstall_std

# Relocate shared library from %_libdir/ to /lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/liblzma.so; do
	t=$(readlink "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# GPL'ed files are not packaged.
rm %buildroot%docdir/COPYING.GPL*

%find_lang xz

%check
make -k check

%define _stripped_files_terminate_build 1
%define _unpackaged_files_terminate_build 1

%files -f xz.lang
%_bindir/*lz*
%_bindir/*xz*
%_man1dir/*lz*.1*
%_man1dir/*xz*.1*

%files -n liblzma
/%_lib/liblzma.so.*
%docdir
%exclude %docdir/examples*
%exclude %docdir/*-file-format.txt

%files -n liblzma-devel
%_includedir/lzma.h
%_includedir/lzma/
%_libdir/liblzma.so
%_pkgconfigdir/liblzma.pc
%dir %docdir
%docdir/examples*
%docdir/*-file-format.txt

%files -n liblzma-devel-static
%_libdir/liblzma.a

%changelog
