%define _unpackaged_files_terminate_build 1

Name: zathura
Version: 0.4.8
Release: alt1

Summary: A lightweight document viewer
License: Zlib
Group: Office
Url: https://pwmt.org/projects/%name/
Vcs: git://pwmt.org/zathura.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): meson
BuildRequires: libgirara-devel >= 0.3.6-alt1
BuildRequires: intltool libgtk+3-devel libsqlite3-devel python3-module-docutils libmagic-devel zlib-devel
BuildRequires: libsynctex-devel
BuildRequires: libseccomp-devel
# For man pages
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
# To create icons
BuildRequires: librsvg-utils

Conflicts: zatura-pdf-poppler < 0.2.5-alt1
Conflicts: zatura-djvu < 0.2.3-alt2
Conflicts: zatura-ps < 0.2.2-alt2
Conflicts: zatura-cb < 0.1.2-alt2

%description
zathura is a highly customizable and functional document viewer based on
the girara user interface library and several document libraries.

This package contains ALT-specific changes so it is NOT original software
from https://pwmt.org.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Requires: libgtk+3-devel libgirara-devel

%description devel
This package contains libraries and header files for
developing applications that use %name.

%prep
%setup
%patch -p1

%build
%meson
%meson_build -v

%install
%meson_install
#  Create directory for plugins
mkdir -p %buildroot%_libdir/zathura
%find_lang %name

%files -f %name.lang
%doc LICENSE AUTHORS
%_bindir/%name
%dir %_libdir/%name
%_desktopdir/*
%_iconsdir/hicolor/*/*/*
%_datadir/metainfo/*.xml
%_man1dir/*
%_man5dir/*
%_datadir/dbus-1/interfaces/org.pwmt.*
%_datadir/bash-completion/completions/*
%_datadir/zsh/site-functions/*
%_datadir/fish/vendor_completions.d/*

%files devel
%_includedir/*
%_libdir/pkgconfig/*.pc

%changelog
