%def_enable snapshot

%define major 1.0
%define api_ver 2.0
%define _noarchpkgconfigdir %_datadir/pkgconfig
%define _libexecdir %_prefix/libexec

%define pkgdocdir %_docdir/lib%name-%version

%def_enable fts
%def_enable docs

Name: zeitgeist
Version: %major.3
Release: alt2

Summary: Framework providing Desktop activity awareness
Group: Office
License: LGPL-2.1 and GPL-2.0
# zeitgeist/loggers/iso_strptime.py is LGPLv3 and the rest LGPLv3+
Url: https://launchpad.net/zeitgeist

%if_disabled snapshot
Source: http://launchpad.net/%name/%major/%version/+download/%name-%version.tar.gz
%else
# VCS: git://anongit.freedesktop.org/zeitgeist/zeitgeist
Source: %name-%version.tar
%endif

Requires: lib%name%api_ver = %version-%release

%define glib_ver 2.36
%define vala_ver 0.22
%define tp_glib_ver 0.18

# can't do buildreq correctly
BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3-devel python3-module-rdflib
BuildRequires: gcc-c++ libsqlite3-devel libdbus-devel
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel libjson-glib-devel
BuildRequires: libxapian-devel
BuildRequires: libtelepathy-glib-devel >= %tp_glib_ver
BuildRequires: gobject-introspection-devel
BuildRequires: vala-tools >= %vala_ver libtelepathy-glib-vala
BuildRequires: pkgconfig(systemd)
%{?_enable_docs:BuildRequires: gtk-doc valadoc}
# for autoreconf
BuildRequires: gettext-tools

%description
Zeitgeist is a service which logs the users's activities and events (files
opened, websites visites, conversations hold with other people, etc.) and makes
relevant information available to other applications.

Note that this package only contains the daemon, which you can use
together with several different user interfaces.

%package -n lib%name%api_ver
Summary: Dynamic library to access the Zeitgeist daemon
Group: System/Libraries

%description -n lib%name%api_ver
Zeitgeist is a service which logs the users's activities and events (files
opened, websites visites, conversations hold with other people, etc.) and makes
relevant information available to other applications.

This package contains the dynamic Zeitgeist library, which provides
access to the Zeitgeist daemon.

%package -n lib%name%api_ver-devel
Summary: Development files for Zeitgeist
Group: Development/C
Requires: lib%name%api_ver = %version-%release

%description -n lib%name%api_ver-devel
Zeitgeist is a service which logs the users's activities and events (files
opened, websites visites, conversations hold with other people, etc.) and makes
relevant information available to other applications.

This package contains the development files for the Zeitgeist library.

%package -n lib%name%api_ver-gir
Summary: GObject introspection data for the Zeitgeist library
Group: System/Libraries
Requires: lib%name%api_ver = %version-%release

%description -n lib%name%api_ver-gir
Zeitgeist is a service which logs the users's activities and events (files
opened, websites visites, conversations hold with other people, etc.) and makes
relevant information available to other applications.

This package provides GObject introspection data for the Zeitgeist library.

%package -n lib%name%api_ver-gir-devel
Summary: GObject introspection devel data for the Zeitgeist library
Group: Development/Other
BuildArch: noarch
Requires: lib%name%api_ver-gir = %version-%release
Requires: lib%name%api_ver-devel = %version-%release

%description -n lib%name%api_ver-gir-devel
Zeitgeist is a service which logs the users's activities and events (files
opened, websites visites, conversations hold with other people, etc.) and makes
relevant information available to other applications.

This package provides GObject introspection devel data for the Zeitgeist library.

%package -n python3-module-%name%api_ver
Summary: Python3 bindings for the Zeitgeist library
Group: Development/Python3
BuildArch: noarch
Requires: lib%name%api_ver = %version-%release

%description -n python3-module-%name%api_ver
Zeitgeist is a service which logs the users's activities and events (files
opened, websites visites, conversations hold with other people, etc.) and makes
relevant information available to other applications.

This package provides Python3 bindings for the Zeitgeist library.

%package -n lib%name%api_ver-devel-doc
Summary: Development documentation for lib%name%api_ver
Group: Development/Documentation
Conflicts: lib%name%api_ver < %version
BuildArch: noarch

%description -n lib%name%api_ver-devel-doc
This package contains development documentation for the Zeitgeist library.


%prep
%setup
subst 's/_have/have/' data/completions/%name-daemon

%build
%define opts --disable-static %{subst_enable fts}
%autoreconf
%configure %opts \
%{subst_enable docs} \
	PYTHON=%__python3
%make_build

%install
%makeinstall_std

%if_enabled docs
install -d -m755 %buildroot%pkgdocdir
cp -aR doc/lib%name/{docs_c/html,docs_vala} %buildroot%pkgdocdir
%endif

%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog NEWS README
%_bindir/%name-daemon
%_bindir/%name-datahub
%_datadir/%name/
%_datadir/dbus-1/services/org.gnome.%name.Engine.service
%_datadir/dbus-1/services/org.gnome.%name.SimpleIndexer.service
%_prefix/lib/systemd/user/%name.service
%_man1dir/%name-*.*
%_sysconfdir/xdg/autostart/%name-datahub.desktop
%_datadir/bash-completion/completions/%name-daemon

%if_enabled fts
%dir %_libexecdir/%name
%_libexecdir/%name/%name-fts
%_prefix/lib/systemd/user/%name-fts.service
%endif

%files -n python3-module-%name%api_ver
%python3_sitelibdir_noarch/zeitgeist/

%files -n lib%name%api_ver
%_libdir/lib%name-%api_ver.so.*

%files -n lib%name%api_ver-devel
%_includedir/%name-%api_ver/
%_libdir/lib%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%_vapidir/%name-%api_ver.deps
%_vapidir/%name-%api_ver.vapi
%_vapidir/%name-datamodel-%api_ver.vapi

%files -n lib%name%api_ver-gir
%_typelibdir/Zeitgeist-2.0.typelib

%files -n lib%name%api_ver-gir-devel
%_girdir/Zeitgeist-2.0.gir

%if_enabled docs
%files -n lib%name%api_ver-devel-doc
%pkgdocdir
%endif

%changelog
