%def_without pgm

Name: zeromq
Version: 4.2.5
Release: alt1

Summary: a software library that lets you quickly design and implement a fast message-based application
Group: System/Libraries
License: GPLv3, LGPLv3

Url: http://www.zeromq.org
Source: %name-%version.tar
Source1: https://raw.githubusercontent.com/zeromq/cppzmq/master/zmq.hpp
Source2: https://raw.githubusercontent.com/zeromq/cppzmq/master/LICENSE
Packager: Vladimir Lettiev <crux@altlinux.ru>

BuildRequires: gcc-c++ libuuid-devel glib2-devel asciidoc xmlto
%{?_with_pgm:BuildRequires: libopenpgm-devel}

Requires: lib%name = %version-%release

%description
The 0MQ lightweight messaging kernel is a library which extends the
standard socket interfaces with features traditionally provided by
specialised messaging middleware products. 0MQ sockets provide an
abstraction of asynchronous message queues, multiple messaging patterns,
message filtering (subscriptions), seamless access to multiple transport
protocols and more.
This package contains 0mq binaries

%package -n lib%name
Group: System/Libraries
Summary: a software library that lets you quickly design and implement a fast message-based application

%description -n lib%name
The 0MQ lightweight messaging kernel is a library which extends the
standard socket interfaces with features traditionally provided by
specialised messaging middleware products. 0MQ sockets provide an
abstraction of asynchronous message queues, multiple messaging patterns,
message filtering (subscriptions), seamless access to multiple transport
protocols and more.
This package contains 0mq library

%package -n lib%name-devel
Group: Development/C++
Summary: a software library that lets you quickly design and implement a fast message-based application
Requires: lib%name = %version-%release

%description -n lib%name-devel
The 0MQ lightweight messaging kernel is a library which extends the
standard socket interfaces with features traditionally provided by
specialised messaging middleware products. 0MQ sockets provide an
abstraction of asynchronous message queues, multiple messaging patterns,
message filtering (subscriptions), seamless access to multiple transport
protocols and more.
This package contains 0mq library headers

%package -n lib%name-cpp-devel
Summary: Development files for cppzmq
Group: Development/C++
License: MIT
Requires: lib%name-devel = %version-%release

%description -n lib%name-cpp-devel
This package contains files for developing C++ %name applications.

%prep
%setup
cp -a %SOURCE2 .

%build
%autoreconf
%configure --disable-static \
	--with-pic \
	--with-gnu-ld \
	%{subst_with pgm}

%make_build

%install
%makeinstall_std
install -m644 -p %SOURCE1 %buildroot%_includedir/

%check
%make check

%files -n lib%name
%_libdir/libzmq.so.*
%doc AUTHORS ChangeLog NEWS
%_man7dir/zmq.7*

%files -n lib%name-devel
%_includedir/*.h
%_libdir/libzmq.so
%_pkgconfigdir/libzmq.pc
%_man3dir/zmq_*3*
%_man7dir/zmq_*7*

%files -n lib%name-cpp-devel
%_includedir/zmq.hpp
%doc LICENSE

%changelog
