%define wwwdir %_datadir/%name
%define phpver 8.1

Summary: A syslog data viewer for the web
Name: LogAnalyzer
Version: 4.1.13
Release: alt1
License: GPLv3+
Group: Monitoring
Url: http://loganalyzer.adiscon.com/
VCS: https://github.com/rsyslog/loganalyzer.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch
BuildArch: noarch
Provides: phplogcon

Requires(pre): webserver-common
Requires: fonts-ttf-vera

BuildPreReq: rpm-macros-webserver-common rpm-macros-apache2

%description
LogAnalyzer project provides an easy to use but powerful front end for
searching, reviewing and analyzing network event data, including
syslog, windows event log and many other event sources.

%package apache2
Group: Networking/WWW
BuildArch: noarch
Summary: apache2 configs for %name
Requires: %name = %EVR
Requires: %name-php%phpver
Requires: apache2-httpd-prefork-like php-engine

%description apache2
%summary

%package php%phpver
Group: Networking/WWW
BuildArch: noarch
Summary: php virtual package  for %name
Provides: %name-php
Requires: %name = %EVR
Requires: php%phpver-mysqli
Requires: php%phpver-ldap php%phpver-pdo php%phpver-mbstring
Requires: php%phpver-gd2

%description php%phpver
%summary

%prep
%setup -n %name-%version
%patch -p1

%build
#rm -rf src/classes/jpgraph
rm -rf src/BitstreamVeraFonts

%install
mkdir -p %buildroot{%_sysconfdir/cron.d,%wwwdir,%_sysconfdir/%name}
cp -aRf src/* %buildroot%wwwdir/

touch %buildroot%_sysconfdir/%name/config.php
ln -s ../../..%_sysconfdir/%name/config.php %buildroot%wwwdir/config.php

install -pDm644 LogAnalyzer-apache.conf %buildroot%apache2_extra_available/%name.conf

# It is the file in the package named Thumbs.db or Thumbs.db.gz, 
# which is normally a Windows image thumbnail database. 
# Such databases are generally useless in packages and were usually 
# accidentally included by copying complete directories from the source tarball.
find $RPM_BUILD_ROOT \( -name 'Thumbs.db' -o -name 'Thumbs.db.gz' \) -print -delete


%files
%doc COPYING INSTALL ChangeLog LogAnalyzer-apache.conf doc
%dir %attr(750,root,%webserver_group) %_sysconfdir/%name
%attr(640,root,%webserver_group) %config(noreplace) %_sysconfdir/%name/config.php
%dir %wwwdir
%wwwdir/*

%files apache2
%config(noreplace) %apache2_extra_available/%name.conf

%files php%phpver

%changelog
