%define optflags_lto %nil

%def_enable egl
%def_enable gles2

%define dri_drivers_add() %{expand:%%global dri_drivers %{?dri_drivers:%dri_drivers,}%{1}}
%define gallium_drivers_add() %{expand:%%global gallium_drivers %{?gallium_drivers:%gallium_drivers,}%{1}}
%define vulkan_drivers_add() %{expand:%%global vulkan_drivers %{?vulkan_drivers:%vulkan_drivers,}%{1}}

%define radeon_arches %ix86 x86_64 aarch64 ppc64le mipsel %e2k loongarch64 riscv64
%define vulkan_radeon_arches %ix86 x86_64 aarch64 ppc64le mipsel %e2k loongarch64 riscv64
%define nouveau_arches %ix86 x86_64 armh aarch64 ppc64le mipsel %e2k riscv64
%define vulkan_nouveau_arches %ix86 x86_64 armh aarch64 ppc64le mipsel %e2k
%define intel_arches %ix86 x86_64
%define vulkan_intel_arches %ix86 x86_64
%define vulkan_virtio_arches %ix86 x86_64 aarch64 ppc64le mipsel loongarch64 riscv64
%define virgl_arches %ix86 x86_64 armh aarch64 ppc64le mipsel %e2k loongarch64 riscv64
%define armsoc_arches %arm aarch64
%define svga_arches %ix86 x86_64

%define gallium_opencl_arches %ix86 x86_64 aarch64 ppc64le mipsel %e2k loongarch64

#VDPAU state tracker requires at least one of the following gallium drivers: r300, r600, radeonsi, nouveau
%define vdpau_arches %radeon_arches %nouveau_arches %virgl_arches
# Mesa builds radeon and nouveau support as megadrivers
%define dri_megadriver_arches %radeon_arches %nouveau_arches
%define gallium_megadriver_arches %radeon_arches %nouveau_arches
# XA state tracker requires at least one of the following gallium drivers: nouveau, freedreno, i915, svga
%define xa_arches %nouveau_arches %armsoc_arches %svga_arches

%gallium_drivers_add softpipe
%gallium_drivers_add llvmpipe
%ifarch %radeon_arches
%dri_drivers_add r100
%dri_drivers_add r200
%gallium_drivers_add r300
%gallium_drivers_add r600
%gallium_drivers_add radeonsi
%endif
%ifarch %intel_arches
%dri_drivers_add i915
%dri_drivers_add i965
%gallium_drivers_add i915
%gallium_drivers_add crocus
%gallium_drivers_add iris
%endif
%ifarch %nouveau_arches
%dri_drivers_add nouveau
%gallium_drivers_add nouveau
%endif
%ifarch %virgl_arches
%gallium_drivers_add virgl
%endif
%ifarch %armsoc_arches
%gallium_drivers_add vc4
%gallium_drivers_add etnaviv
%gallium_drivers_add freedreno
%gallium_drivers_add panfrost
%gallium_drivers_add lima
%gallium_drivers_add tegra
%gallium_drivers_add v3d
%endif
%ifarch %svga_arches
%gallium_drivers_add svga
%endif
%ifarch aarch64
%gallium_drivers_add asahi
%endif
%gallium_drivers_add zink
%ifarch %vulkan_intel_arches
%vulkan_drivers_add intel
%vulkan_drivers_add intel_hasvk
%endif
%ifarch %vulkan_radeon_arches
%vulkan_drivers_add amd
%endif
%ifarch %vulkan_nouveau_arches
%vulkan_drivers_add nouveau
%endif
%ifarch %vulkan_virtio_arches
%vulkan_drivers_add virtio
%endif
%ifarch %armsoc_arches
%vulkan_drivers_add freedreno
%vulkan_drivers_add broadcom
%vulkan_drivers_add panfrost
%vulkan_drivers_add imagination-experimental
%endif
%ifarch loongarch64
# LS7A1000 and LS7A2000 chipsets, and Loongson SoCs have vivante GPU
%gallium_drivers_add etnaviv
%endif
%vulkan_drivers_add swrast

%define ver_major 25.1
%define ver_minor 9

Name: Mesa
Version: %ver_major.%ver_minor
Release: alt1
Epoch: 4
License: MIT
Summary: OpenGL compatible 3D graphics library
Group: System/Libraries
Url: http://www.mesa3d.org

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch: %name-%version.patch

BuildPreReq: /proc
BuildRequires(pre): meson
BuildRequires: gcc-c++ indent flex libXdamage-devel libXext-devel libXft-devel libXmu-devel libXi-devel libXrender-devel libXxf86vm-devel
BuildRequires: libdrm-devel libexpat-devel libselinux-devel libxcb-devel libSM-devel libtinfo-devel libudev-devel
BuildRequires: libXdmcp-devel libffi-devel libelf-devel libva-devel libvdpau-devel xorg-proto-devel libxshmfence-devel
BuildRequires: libXrandr-devel libnettle-devel libelf-devel zlib-devel libwayland-client-devel libwayland-server-devel
BuildRequires: libwayland-egl-devel python3-module-mako-tests wayland-protocols libsensors-devel libzstd-devel
BuildRequires: libglvnd-devel rpm-build-python3 glslang python3-module-docutils python3-module-ply python3-module-yaml
BuildRequires: llvm20.1-devel clang20.1-devel
%ifarch %gallium_opencl_arches
BuildRequires: libclc-devel libLLVMSPIRVLib-devel libspirv-tools-devel
%endif
%ifarch %vulkan_intel_arches %vulkan_radeon_arches %vulkan_virtio_arches %vulkan_nouveau_arches
BuildRequires: libvulkan-devel
%endif
%ifarch %vulkan_nouveau_arches
BuildRequires: cbindgen rust rust-bindgen
%endif
%ifnarch %e2k
BuildRequires: libunwind-devel
%endif

%description
Mesa is an OpenGL compatible 3D graphics library

%package -n libGLX-mesa
Summary: OpenGL 1.3 compatible 3D graphics library for X Window server
Group: System/Libraries
Conflicts: libGL < 4:19.2.2-alt1

%description -n libGLX-mesa
Mesa is an OpenGL compatible 3D graphics library

%package -n libGL-devel
Summary: Development files for Mesa Library
Group: Development/C
Requires: libglvnd-devel >= 1.2.0 libGLX-mesa = %epoch:%version-%release

%description -n libGL-devel
libGL-devel contains the libraries and header files needed to
develop programs which make use of Mesa

%package -n libEGL-mesa
Summary: Mesa EGL library
Group: System/Libraries

%description -n libEGL-mesa
Mesa EGL library

%package -n libEGL-devel
Summary: Mesa libEGL development package
Group: Development/C
Requires: libglvnd-devel >= 1.2.0

%description -n libEGL-devel
Mesa libEGL development package

%package -n libgbm
Summary: GBM buffer management library
Group: System/Libraries

%description -n libgbm
GBM buffer management library

%package -n libgbm-devel
Summary: GBM buffer management development package
Group: Development/C

%description -n libgbm-devel
GBM buffer management development package

%package -n libxatracker
Summary: Mesa XA state tracker
Group: System/Libraries

%description -n libxatracker
Xorg Gallium3D acceleration library

%package -n libxatracker-devel
Summary: Mesa XA state tracker development package
Group: Development/C

%description -n libxatracker-devel
Xorg Gallium3D acceleration development package

%package -n libMesaOpenCL
Summary: Mesa OpenCL runtime library
Group: System/Libraries
Requires: ocl-icd libclc

%description -n libMesaOpenCL
This package contains the mesa implementation of the OpenCL (Open Compute
Language) library, which is intended for use with an ICD loader. OpenCL
provides a standardized interface for computational analysis on graphical
processing units.

%package -n libd3d
Summary: Mesa Direct3D9 state tracker
Group: System/Libraries

%description -n libd3d
%summary

%package -n libd3d-devel
Summary: Mesa Direct3D9 state tracker development package
Group: Development/C

%description -n libd3d-devel
%summary

%package -n xorg-dri-swrast
Summary: Mesa software rendering libraries
Group: System/X11
Requires: libvulkan1

%description -n xorg-dri-swrast
Mesa software rendering libraries

%package -n xorg-dri-intel
Summary: Intel DRI driver
Group: System/X11
Requires: libva-driver-intel
%ifarch x86_64
Requires: libva-intel-media-driver
%endif

%description -n xorg-dri-intel
DRI driver for Intel i8xx, i9xx

%package -n xorg-dri-radeon
Summary: ATI RADEON DRI driver
Group: System/X11
%ifarch %vdpau_arches
Requires: libvdpau
%endif

%description -n xorg-dri-radeon
DRI driver for ATI R100, R200, R300, R400, R500

%package -n xorg-dri-nouveau
Summary: nVidia DRI driver
Group: System/X11
%ifarch %vdpau_arches
Requires: libvdpau
%endif

%description -n xorg-dri-nouveau
DRI driver for nVidia

%package -n xorg-dri-vmwgfx
Summary: VMWare DRI driver
Group: System/X11

%description -n xorg-dri-vmwgfx
DRI driver for VMWare

%package -n xorg-dri-armsoc
Summary: SoC DRI drivers
Group: System/X11

%description -n xorg-dri-armsoc
DRI drivers for various SoCs

%package -n xorg-dri-virtio
Summary: VirtIO DRI driver
Group: System/X11
Provides: xorg-dri-virgl
Obsoletes: xorg-dri-virgl < %epoch:%version-%release

%description -n xorg-dri-virtio
DRI driver for VirtIO

%package -n mesa-dri-drivers
Summary: Mesa-based DRI drivers
Group: System/X11
%ifarch %vulkan_radeon_arches
Provides: mesa-vulkan-drivers = %epoch:%version-%release
%endif
%ifarch %vdpau_arches
Provides: mesa-vdpau-drivers = %epoch:%version-%release
%endif
Requires: xorg-dri-swrast = %epoch:%version-%release
%ifarch %radeon_arches
Requires: xorg-dri-radeon = %epoch:%version-%release
%endif
%ifarch %nouveau_arches
Requires: xorg-dri-nouveau = %epoch:%version-%release
%endif
%ifarch %intel_arches
Requires: xorg-dri-intel = %epoch:%version-%release
%endif
%ifarch %armsoc_arches
Requires: xorg-dri-armsoc = %epoch:%version-%release
%endif
%ifarch %svga_arches
Requires: xorg-dri-vmwgfx = %epoch:%version-%release
%endif
%ifarch %virgl_arches
Requires: xorg-dri-virtio = %epoch:%version-%release
%endif

%description -n mesa-dri-drivers
Mesa-based DRI drivers

%set_verify_elf_method unresolved=relaxed

%prep
%setup -q
%patch -p1

tar -xf subprojects.tar

%build
%meson \
	-Dplatforms=x11,wayland \
	-Dgallium-nine=true \
	-Dgallium-drivers='%{?gallium_drivers}' \
	-Dvulkan-drivers='%{?vulkan_drivers}' \
	-Dvulkan-layers='device-select, overlay' \
	-Dvideo-codecs='vc1dec, h264dec, h264enc, h265dec, h265enc, av1dec, av1enc, vp9dec' \
%ifarch %vdpau_arches
	-Dgallium-vdpau=enabled \
%endif
	-Dlegacy-x11=dri2 \
%ifarch %radeon_arches
	-Dllvm=enabled \
	-Dshared-llvm=enabled \
%endif
	-Dshared-glapi=enabled \
%if_enabled egl
	-Degl=enabled \
%else
	-Degl=disabled \
%endif
%if_enabled gles2
	-Dgles2=enabled \
%else
	-Dgles2=disabled \
%endif
%ifarch %xa_arches
	-Dgallium-xa=enabled \
%else
	-Dgallium-xa=disabled \
%endif
%ifarch armh
	-Dlibunwind=false \
%endif
	-Dgles1=disabled \
	-Dopengl=true \
	-Dglvnd=enabled \
	-Ddri-drivers-path=%_libdir/X11/modules/dri \
	-Db_ndebug=true \
%ifarch %gallium_opencl_arches
	-Dgallium-opencl=icd \
%endif
#

%meson_build

RST2HTML=rst2html
if [ ! -x %_bindir/$RST2HTML ]; then
	RST2HTML=rst2html.py
fi
for i in $(seq 0 %ver_minor); do
	if [ -f %_builddir/%name-%version/docs/relnotes/%ver_major.$i.rst ]; then
		$RST2HTML %_builddir/%name-%version/docs/relnotes/%ver_major.$i.rst %_builddir/%name-%version/%ver_major.$i.html
	fi
done

%install
%meson_install

mkdir -p %buildroot%_sysconfdir
touch %buildroot%_sysconfdir/drirc

%ifarch %armsoc_arches
find %buildroot%_libdir/X11/modules/dri/ -type l | sed -ne "s|^%buildroot||p" > xorg-dri-armsoc.list
%ifarch %gallium_opencl_arches
rm -f %buildroot%_libdir/gallium-pipe/*.la
find %buildroot%_libdir/gallium-pipe/ -type f | sed -ne "s|^%buildroot||p" >> xorg-dri-armsoc.list
sed -i '/.*pipe_r[a236].*/d' xorg-dri-armsoc.list
%endif
sed -i '/.*swrast.*/d' xorg-dri-armsoc.list
sed -i '/.*virtio.*/d' xorg-dri-armsoc.list
sed -i '/.*nouveau.*/d' xorg-dri-armsoc.list
sed -i '/.*dri\/r[a236].*/d' xorg-dri-armsoc.list
sed -i '/.*zink.*/d' xorg-dri-armsoc.list
%endif

#define _unpackaged_files_terminate_build 1

%files -n libGLX-mesa
%doc %ver_major.*.html
%_libdir/libGLX_mesa.so.*
%_libdir/libgallium-%version.so
%dir %_libdir/gbm
%_libdir/gbm/dri_gbm.so

%files -n libGL-devel
%_includedir/GL/internal
%_libdir/libGLX_mesa.so
%_pkgconfigdir/dri.pc

%if_enabled egl
%files -n libEGL-mesa
%_libdir/libEGL_mesa.so.*
%_datadir/glvnd/egl_vendor.d/50_mesa.json

%files -n libEGL-devel
%_includedir/EGL/eglext_angle.h
%_includedir/EGL/eglmesaext.h
%_libdir/libEGL_mesa.so
%endif

%files -n libgbm
%_libdir/libgbm.so.*

%files -n libgbm-devel
%_includedir/gbm*.h
%_libdir/libgbm.so
%_pkgconfigdir/gbm.pc

%ifarch %xa_arches
%files -n libxatracker
%_libdir/libxatracker.so.*

%files -n libxatracker-devel
%_includedir/xa_*.h
%_libdir/libxatracker.so
%_pkgconfigdir/xatracker.pc
%endif

%ifarch %gallium_opencl_arches
%files -n libMesaOpenCL
%dir %_sysconfdir/OpenCL
%dir %_sysconfdir/OpenCL/vendors
%_sysconfdir/OpenCL/vendors/mesa.icd
%_libdir/libMesaOpenCL.so.*
%endif

%files -n libd3d
%dir %_libdir/d3d
%_libdir/d3d/*.so.*

%files -n libd3d-devel
%_includedir/d3dadapter
%_libdir/d3d/*.so
%_pkgconfigdir/d3d.pc

%files -n xorg-dri-swrast
%ghost %_sysconfdir/drirc
%dir %_datadir/drirc.d
%_datadir/drirc.d/00-mesa-defaults.conf
%_libdir/X11/modules/dri/*swrast*_dri.so
%_libdir/X11/modules/dri/libdril_dri.so
%_libdir/X11/modules/dri/zink_dri.so
%ifarch %gallium_opencl_arches
%dir %_libdir/gallium-pipe
%_libdir/gallium-pipe/pipe_swrast.so
%endif
%_libdir/libvulkan_lvp.so
%_datadir/vulkan/icd.d/lvp_icd*.json
%_bindir/mesa-overlay-control.py
%_libdir/libVkLayer_MESA*.so
%_datadir/vulkan/*plicit_layer.d/VkLayer_MESA*.json

%ifarch %virgl_arches
%files -n xorg-dri-virtio
%_libdir/X11/modules/dri/virtio_gpu_dri.so
%_libdir/dri/virtio_gpu_drv_video.so
%_libdir/vdpau/libvdpau_virtio_gpu.so*
%ifarch %vulkan_virtio_arches
%_libdir/libvulkan_virtio.so
%_datadir/vulkan/icd.d/virtio_icd*.json
%endif
%endif

%ifarch %intel_arches
%files -n xorg-dri-intel
%_libdir/X11/modules/dri/i9?5_dri.so
%_libdir/X11/modules/dri/crocus_dri.so
%_libdir/X11/modules/dri/iris_dri.so
%ifarch %vulkan_intel_arches
%_libdir/libvulkan_intel.so
%_libdir/libvulkan_intel_hasvk.so
%_datadir/vulkan/icd.d/intel_icd*.json
%_datadir/vulkan/icd.d/intel_hasvk_icd*.json
%ifarch %gallium_opencl_arches
%_libdir/gallium-pipe/pipe_i9?5.so
%_libdir/gallium-pipe/pipe_crocus.so
%_libdir/gallium-pipe/pipe_iris.so
%endif
%endif
%endif

%ifarch %nouveau_arches
%files -n xorg-dri-nouveau
%_libdir/X11/modules/dri/nouveau_*dri.so
%_libdir/dri/nouveau_drv_video.so
%_libdir/vdpau/libvdpau_nouveau.so*
%ifarch %vulkan_nouveau_arches
%_libdir/libvulkan_nouveau.so
%_datadir/vulkan/icd.d/nouveau_icd*.json
%endif
%ifarch %gallium_opencl_arches
%_libdir/gallium-pipe/pipe_nouveau.so
%endif
%endif

%ifarch %radeon_arches
%files -n xorg-dri-radeon
%_libdir/X11/modules/dri/radeon*_dri.so
%_libdir/X11/modules/dri/r?00_dri.so
%_libdir/vdpau/libvdpau_r*.so*
%_libdir/dri/r*_drv_video.so
%ifarch %gallium_opencl_arches
%_libdir/gallium-pipe/pipe_r*.so
%endif
%ifarch %vulkan_radeon_arches
%_libdir/libvulkan_radeon.so
%_datadir/vulkan/icd.d/radeon_icd*.json
%_datadir/drirc.d/00-radv-defaults.conf
%endif
%endif

%ifarch %svga_arches
%files -n xorg-dri-vmwgfx
%_libdir/X11/modules/dri/vmwgfx_dri.so
%ifarch %gallium_opencl_arches
%_libdir/gallium-pipe/pipe_vmwgfx.so
%endif
%endif

%ifarch %armsoc_arches
%files -n xorg-dri-armsoc -f xorg-dri-armsoc.list
%_libdir/libvulkan_freedreno.so
%_libdir/libvulkan_broadcom.so
%_libdir/libvulkan_panfrost.so
%_libdir/libvulkan_powervr_mesa.so
%_libdir/libpowervr_rogue.so
%_datadir/vulkan/icd.d/freedreno_icd*.json
%_datadir/vulkan/icd.d/broadcom_icd*.json
%_datadir/vulkan/icd.d/panfrost_icd*.json
%_datadir/vulkan/icd.d/powervr_mesa_icd*.json
%endif

%files -n mesa-dri-drivers

%changelog
