# be ready to change gnustepdir to /usr/lib/GNUstep
%define gnustepdir %_libdir/GNUstep
%define wmdatadir /usr/share/WindowMaker

%define WINGs_SOVER 3
%define WUtil_SOVER 5
%define wraster_SOVER 6

%def_disable debug

%define frame_border   navy

Name: WindowMaker
Version: 0.96.0
Release: alt2
Packager: %packager

Summary: A window manager for the X Window System
Group: Graphical desktop/Window Maker
License: GPLv2+
URL: http://windowmaker.org

Source0: %name-%version.tar
Source1: altlinux.tar

Patch0: wmgenmenu.patch
Patch1: WindowMaker-alt-Makefile.patch
# 5561199c871293cca0b3dc2c6feff0d7783111c6
Patch2: 0002-wmaker-allow-alt-tabbed-windows-over-fullscreen.patch
# 6429847494fbcd84e2bab026c3fd9239c7cf8927
Patch3: 0001-wmaker-fix-stacking-order-of-dock-and-fullscreen.patch

Requires: xvt, wmsetbg = %version-%release, libWINGs = %version-%release, cpp
Requires: xlockmore
Requires: design-graphics
Obsoletes: windowmaker, windowmaker-devel, windowmaker-libs
Obsoletes: wmakerconf <= 2.5

# Automatically added by buildreq on Sun Mar 22 2009
BuildRequires: libICE-devel libXext-devel libXft-devel libXinerama-devel libXmu-devel libXpm-devel libgif-devel libjpeg-devel libpng-devel libtiff-devel

%description
Window Maker is an X11 window manager which emulates the look and feel of the
NeXTSTEP (TM) graphical user interface. It is relatively fast, feature rich and
easy to configure and use. Window Maker is part of the official GNU project,
which means that Window Maker can interoperate with other GNU projects, such as
GNOME.

Window Maker allows users to switch themes 'on the fly,' to place favorite
applications on either an application dock, similar to AfterStep's Wharf or on
a workspace dock, a 'clip' which extends the application dock's usefulness.

%description -l ru_RU.UTF-8
Window Maker - это менеджер окон системы X11, эмулирующий графический
интерфейс системы NeXTSTEP (TM). Отличается высоким быстродействием,
лёгкой настраиваемостью и удобством использования. Window Maker позволяет
менять темы без перезапуска, размещать часто используемые приложения на
док, прообраз дока Mac OSX, аналогичный Wharf'у оконного менеджера
AfterStep, или же на 'скрепку' - переключатель рабочих столов.

%package -n libWINGs
Summary: WINGs - WINGs Is Not GNUstep
Group: System/Libraries
Requires: libwraster = %version-%release
Provides: libwings = %version-%release

%description -n libWINGs
WINGs is a small widget set with the N*XTSTEP look and feel. It's API
is inspired in OpenStep and it's implementation borrows some ideas
from Tk. It has a reasonable set of widgets, sufficient for building
small applications (like a CDPlayer or hacking something like rxvt). It
also has other functions that are usefull for applications, like a
User Defaults alike configuration manager and a notification system.

%description -l ru_RU.UTF-8 -n libWINGs
WINGs - небольшая библиотека компонент для системы X11, эмулирующая NeXTSTEP.
API библиотеки навеен OpenStep, в реализации использовались идеи
из Tk. Библиотека реализует небольшой набор виджетов, вполне достаточный
для разработки интерфейсов небольших программ (таких как CDPlayer или rxvt).
Кроме того, библиотека содержит дополнительные функции, полезные для
разработки приложений, такие как система уведомлений и менеджер настроек.


%package -n libWINGs-devel
Summary: Development files for WINGs library
Group: Development/C
Requires: libWINGs = %version-%release
Requires: libwraster-devel = %version-%release
Provides: libwings-devel = %version-%release
Provides: WindowMaker-devel = %version-%release
Obsoletes: WindowMaker-devel

%description -n libWINGs-devel
This package contains files needed for developing programs with
WINGs.

%description -l ru_RU.UTF-8 -n libWINGs-devel
В этом пакете содержатся файлы, необходимые для разработки программ,
использующих библиотеку WINGs.

%package -n libwraster
Summary: WindowMaker raster graphics library
Group: System/Libraries

%description -n libwraster
This library is used to manipulate images and convert them to
a format that can be displayed through the X window system.
Read the wraster.h header for an idea of what is available

%description -l ru_RU.UTF-8 -n libwraster
Эта библиотека используется для различных манипуляций с изображениями
и конвертирования их в форматы, подходящие для отображения средствами
X11.

%package -n libwraster-devel
Summary: Development files for wraster library
Group: Development/C
Requires: libwraster = %version-%release

%description -n libwraster-devel
This package contains files needed for developing programs
which manipulate images.

%description -l ru_RU.UTF-8 -n libwraster-devel
В этом пакете содержатся файлы, необходимые для разработки программ,
использующих библиотеку libwraster.

%package -n libWMaker
Summary: WindowMaker library
Group: System/Libraries

%description -n libWMaker
This library is used to provide api to WindowMaker.
Currently only FSViewer is using it.

%description -l ru_RU.UTF-8 -n libWMaker
Эта библиотека предоставляет интерфейс для сторонних
приложений. В настоящий момент используется только
программой FSViewer.

%package -n libWMaker-devel
Summary: Development files for WMaker library
Group: Development/C
Requires: libWMaker = %version-%release

%description -n libWMaker-devel
This package contains files needed for developing programs
which manipulate images.

%description -l ru_RU.UTF-8 -n libwraster-devel
В этом пакете содержатся файлы, необходимые для разработки программ,
использующих библиотеку libWMaker.

%package -n wmsetbg
Summary: Utility for root window image setting
Group: Graphical desktop/Window Maker

%description -n wmsetbg
Utility for root window image setting

%description -l ru_RU.UTF-8 -n wmsetbg
Утилита, позволяющая размещать изображения на рабочий стол.

%prep
%setup -n %name-%version
%setup -a 1 
%patch0 -p1
%patch1 -p1
%patch2 -p1 -R
%patch3 -p1 -R

sed -i 's,/usr/lib/GNUstep,%gnustepdir,g' \
	altlinux/etc/X11/WindowMaker/WMWindowAttributes

%build

GNUSTEP_LOCAL_ROOT=%gnustepdir
LINGUAS="bg cs da de el es et fi fr gl hr hu it ja ko nl no pl pt ro ru sk sv tr zh_CN zh_TW"
export LINGUAS GNUSTEP_LOCAL_ROOT

%add_optflags -DNEWAPPICON
%autoreconf
%configure \
	--bindir=%_bindir \
	--sysconfdir=%_sysconfdir/X11 \
	--datadir=%_datadir \
	--libdir=%_libdir \
	--includedir=%_includedir \
	--mandir=%_mandir \
	--enable-shared \
	--disable-static \
	--with-pixmapdir=%_datadir \
	--with-appspath=%gnustepdir/Apps \
	--with-menu-textdomain=menu-messages \
                            --localedir=%_datadir/locale \
	--with-gnustepdir=%gnustepdir \
	--enable-modelock \
	--enable-xinerama \
	--enable-usermenu \

# Set the window border color to another arbitrary value (mike@, #15667)
subst 's,^\(#define FRAME_BORDER_COLOR \)"black",\1"%frame_border",' \
       src/wconfig.h

%make_build

%install
%makeinstall_std
pushd altlinux
tar cf - . | tar xf - -C "%buildroot"
popd
sed -e 's@#wmdatadir#@%wmdatadir@' <$RPM_BUILD_ROOT/%wmdatadir/wmmacros \
	>$RPM_BUILD_ROOT/%wmdatadir/wmmacros.t
mv $RPM_BUILD_ROOT/%wmdatadir/wmmacros.t $RPM_BUILD_ROOT/%wmdatadir/wmmacros

sed -i -e 's@#wmdatadir#@%wmdatadir@' %buildroot%wmdatadir/wmmacros 

ln -s `relative %gnustepdir/Applications/WPrefs.app/WPrefs %_bindir/` \
	%buildroot%_bindir/

rm -f %buildroot%wmdatadir/menu*
rm -f %buildroot%wmdatadir/plmenu*
rm -f %buildroot%wmdatadir/autostart.sh
rm -f %buildroot%wmdatadir/exitscript.sh
rm -rf %buildroot/usr/share/man/sk/

%find_lang WPrefs
%find_lang WindowMaker
%find_lang WINGs

cat WPrefs.lang >> WindowMaker.lang
#cat WINGs.lang >> WindowMaker.lang

#find_lang name WPrefs geticonset getstyle seticons setstyle wdwrite wmaker wmsetbg wxcopy wxpaste
#find_lang --output=WINGs.lang WINGs

rm -rf %buildroot%_mandir/cs

%files -f %name.lang
%doc AUTHORS BUGFORM BUGS COPYING COPYING.WTFPL FAQ INSTALL-WMAKER README* TODO
%config(noreplace) %_sysconfdir/X11/WindowMaker
%config(noreplace) %_sysconfdir/menu-methods/WindowMaker
%config(noreplace) %_sysconfdir/X11/wmsession.d/*
%_bindir/convertfonts
%_bindir/geticonset
%_bindir/getstyle
%_bindir/seticons
%_bindir/setstyle
%_bindir/wdread
%_bindir/wdwrite
%_bindir/wmagnify
%_bindir/wmaker
%_bindir/wmaker.inst
%_bindir/wmgenmenu
%_bindir/wmiv
%_bindir/wmmenugen
%_bindir/wxcopy
%_bindir/wxpaste

%_bindir/startwindowmaker
%_bindir/WindowMaker-Terminal
%_bindir/WindowMaker-Lock
%_bindir/WPrefs

%_man1dir/*
%_mandir/ru/man1/*
%_menudir/*
%_miconsdir/*.xpm
%_niconsdir/*.xpm
%_liconsdir/*.xpm
%_datadir/xsessions/WindowMaker.desktop

%gnustepdir/Applications/WPrefs.app
%dir %wmdatadir
%wmdatadir/*
%dir %_datadir/WINGs
%_datadir/WINGs/*

%files -n libWINGs -f WINGs.lang
%doc WINGs/NEWS WINGs/README
%_libdir/libWINGs.so.%WINGs_SOVER
%_libdir/libWINGs.so.%WINGs_SOVER.*
%_libdir/libWUtil.so.%WUtil_SOVER
%_libdir/libWUtil.so.%WUtil_SOVER.*

%files -n libWINGs-devel
%_includedir/WINGs
%_libdir/libWINGs.so
%_libdir/libWUtil.so
%_libdir/pkgconfig/WINGs.pc
%_libdir/pkgconfig/WUtil.pc

%files -n libwraster
%_libdir/libwraster.so.%wraster_SOVER
%_libdir/libwraster.so.%wraster_SOVER.*

%files -n libwraster-devel
%_includedir/wraster.h
%_libdir/libwraster.so
%_libdir/pkgconfig/wrlib.pc

%files -n libWMaker
%_libdir/libWMaker.so.*
%_libdir/pkgconfig/wmlib.pc

%files -n libWMaker-devel
%_includedir/WMaker.h
%_libdir/libWMaker.so

%files -n wmsetbg
%_bindir/wmsetbg

%changelog
