Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           args4j
Version:        2.33
Release:        alt1_19jpp11
Summary:        Java command line arguments parser
License:        MIT
URL:            https://args4j.kohsuke.org
Source0:        https://github.com/kohsuke/%{name}/archive/%{name}-site-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)

# Fix build on Java 11/17
Patch0: 0001-Remove-usage-of-internal-sun-class-removed-in-Java-9.patch

# Stopped shipping these unused subpackages in F34
Obsoletes: %{name}-tools < 2.33-13
Obsoletes: %{name}-parent < 2.33-13
Source44: import.info

%description
args4j is a small Java class library that makes it easy
to parse command line options/arguments in your CUI application.
- It makes the command line parsing very easy by using annotations
- You can generate the usage screen very easily
- You can generate HTML/XML that lists all options for your documentation
- Fully supports localization
- It is designed to parse javac like options (as opposed to GNU-style
  where ls -lR is considered to have two options l and R)

%package javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n %{name}-%{name}-site-%{version}
%patch0 -p1

# removing bundled stuff
find -name '*.class' -exec rm -f '{}' \;
find -name '*.jar' -exec rm -f '{}' \;

# Not needed for RPM builds
%pom_remove_plugin -r :maven-site-plugin

# we don't need these now
%pom_disable_module args4j-maven-plugin
%pom_disable_module args4j-maven-plugin-example
%pom_disable_module args4j-tools

# Remove reliance on the parent pom
%pom_remove_parent

# Remove hard-coded source/target
%pom_xpath_remove pom:plugin/pom:configuration/pom:target
%pom_xpath_remove pom:plugin/pom:configuration/pom:source

# Don't package the parent pom
%mvn_package :args4j-site __noinstall

# install also compat symlinks
%mvn_file ":{*}" %{name}/@1 @1

%build
%mvn_build -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8 -Dmaven.compiler.release=11

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference %{name}/LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference %{name}/LICENSE.txt

%changelog
