%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%global optflags_lto %optflags_lto -ffat-lto-objects

Name: barcode
Version: 0.99
Release: alt3
Group: Graphics
Summary: Utility to generate printable barcodes in PostScript format
Summary(ru_RU.UTF-8): Утилита для генерации штрих-кодов для печати в формате PostScript
License: GPLv3
Url: http://www.gnu.org/software/barcode/barcode.html

Source: %name-%version.tar
Patch0: barcode-0.99-info.patch
Patch1: barcode-0.98-leak-fix.patch
Patch2: barcode-0.99-fix-renamed-include.patch
Patch3: barcode-0.99-gcc-10.patch

# Automatically added by buildreq on Wed Jul 08 2009
BuildRequires: ghostscript-utils /usr/bin/tex gcc
# explicitly added texinfo for info files
BuildRequires: texinfo

%description 
The package is meant to solve most needs in barcode creation with a
conventional printer. It can create printouts for the conventional
product tagging standards: UPC-A, UPC-E, EAN-13, EAN-8, ISBN, as well
as a few other formats. Output is generated as either Postscript or
Encapsulated Postscript (other back-ends may be added if needed).

This package includes a command-line barcode generation frontend.

%description -l ru_RU.UTF-8
Этот пакет призван удовлетворить большинство потребностей по созданию
штрих-кодов с помощью обычного принтера. Он может выдавать распечатки
всех основных стандартных кодов, таких, как UPC-A, UPC-E, EAN-13,
EAN-8, ISBN и еще нескольких. Вывод генерируется в Postscript или
Encapsulated Postscript (возможно также добавление иных форматов при
необходимости).

В пакет входят и библиотека, и утилита командной строки, так что вы
можете добавить поддержку генерации штрих-кодов в ваше приложение.

%package -n libbarcode-devel-static
Summary: Library to generate printable barcodes in PostScript format
Summary(ru_RU.UTF-8): Библиотека для генерации штрих-кодов для печати в формате PostScript
Group: System/Libraries
Provides: libbarcode-static-devel = %EVR
Obsoletes: libbarcode-static-devel

%description -n libbarcode-devel-static
The package is meant to solve most needs in barcode creation with a
conventional printer. It can create printouts for the conventional
product tagging standards: UPC-A, UPC-E, EAN-13, EAN-8, ISBN, as well
as a few other formats. Output is generated as either Postscript or
Encapsulated Postscript (other back-ends may be added if needed).

The package includes a static library.

%prep
%setup
%patch0 -p2
%patch1 
%patch2 -p1
%patch3 -p2

# don't build unpackaged binary
sed -i -e 's:barcode sample:barcode:' Makefile.am

%build
%autoreconf
%configure

%make

%install
%makeinstall
install -Dm0644 .libs/libbarcode.a %buildroot%_libdir/libbarcode.a
install -Dm0644 barcode.h %buildroot%_includedir/barcode.h
sed -i '/^#include.*config.h"$/d' %buildroot%_includedir/barcode.h

%files
%defattr(0644,root,root,0755)
%doc README INSTALL TODO NEWS
%attr(0755,root,root) %_bindir/barcode
%_infodir/barcode.info*

%files -n libbarcode-devel-static
%_includedir/barcode.h
%_libdir/libbarcode.a

%changelog
