Name: bluefish
Summary: A GTK3 web development application for experienced users
Version: 2.2.17
Release: alt1
Epoch: 2

Url: https://bluefish.openoffice.nl
License: GPL-3.0-or-later
Group: Editors

# Source-url: https://sourceforge.net/projects/bluefish/files/bluefish/%version/bluefish-%version.tar.gz/download
Source: %name-%version.tar

# Russian translation
#Source1: ru.po
#Source2: plugin_about-ru.po
#Source3: plugin_htmlbar-ru.po

# Fedora patches
# Avoid potential aliasing issues in zencoding plugin
Patch0: bluefish-2.2.13-strict-aliasing.patch

# Avoid use of /usr/bin/env in shipped scripts
# Also change /usr/bin/python → /usr/bin/python3 (for now)
Patch1: bluefish-2.2.17-shellbang.patch

Patch3: bluefish-2.2.12-fix-command-chmod-a-x.patch

Patch4: bluefish-2.2.17-russian-translation.patch

Obsoletes: bluefish-common =< %EVR

AutoProv: nopython3

%add_python3_path %_datadir/%name

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: intltool
BuildRequires: libgtk+3-devel
BuildRequires: libgucharmap-devel
BuildRequires: libxml2-devel
BuildRequires: libenchant-devel
BuildRequires: libappstream-glib

%description
Bluefish is a powerful editor for experienced web designers and programmers.
Bluefish supports many programming and markup languages, but it focuses on
editing dynamic and interactive websites

%prep
%setup
#for N in src/plugin_*/po; do ln -s /usr/share/intltool/Makefile.in.in $N/;done
#for N in src/plugin_*/po; do test -r $N/Makefile.in.in && echo $N || ln -s /usr/share/intltool/Makefile.in.in $N/;done
find data -type f -name \*.py -exec sed -i 's/\r//' {} \;

%patch0
%patch1 -p2
%patch3 -p2
%patch4 -p1

# Update russian translation
#cp %SOURCE1 po/ru.po
#cp %SOURCE2 src/plugin_about/po/ru.po
#cp %SOURCE3 src/plugin_htmlbar/po/ru.po

# Update binary translation
rm src/plugin_about/po/ru.gmo
rm src/plugin_htmlbar/po/ru.gmo
msgfmt src/plugin_about/po/ru.po -o src/plugin_about/po/ru.gmo
msgfmt src/plugin_htmlbar/po/ru.po -o src/plugin_htmlbar/po/ru.gmo

%build
%autoreconf
%configure --disable-update-databases --disable-xml-catalog-update
%make_build

%install
# No makeinstall macros here, because of hardcoded DESTDIR-only
make install DESTDIR=%buildroot

# Unpackaged files
rm %buildroot%_libdir/%name/*.la

%find_lang %name
for c in `echo src/plugin_*`; do
  %find_lang %{name}_`basename $c`
done
cat %{name}_plugin_*.lang >> %name.lang

%files -f %name.lang
%_bindir/*
%_libdir/%name
%_desktopdir/%name.desktop
%_datadir/metainfo/%name.appdata.xml
%exclude %_defaultdocdir/%name
%doc data/bflang/sample.bflang2 AUTHORS COPYING ChangeLog README TODO
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/pixmaps/*
%_datadir/mime/packages/*
%_iconsdir/hicolor/*/*/*.??g
%_man1dir/*
%dir %_datadir/xml/%name
%_datadir/xml/%name/*

%changelog
