%ifdef _priority_distbranch
%define altbranch %_priority_distbranch
%else
%define altbranch sisyphus
%endif
%if "%altbranch" == "%nil"
%define altbranch sisyphus
%endif

%define brand alt
%define Brand ALT
%define theme server
%define Theme Server
%define codename Mendelevium
%define icon_theme AltWorkstation

%if "%altbranch" == "sisyphus"
%define status sisyphus_alpha
%define status_en sisyphus_alpha
%else
%define status %nil
%define status_en %nil
%endif

%define flavour %brand-%theme

%def_enable flickfree

%define design_graphics_abi_epoch 0
%define design_graphics_abi_major 12
%define design_graphics_abi_minor 0
%define design_graphics_abi_bugfix 0

%define _unpackaged_files_terminate_build 1

Name: branding-%flavour
Version: 11.1
Release: alt3
Url: https://basealt.ru

BuildRequires(pre): rpm-macros-branding
BuildRequires: libalternatives-devel
BuildRequires: qt6-base-devel

BuildRequires: ImageMagick fontconfig bc
BuildRequires: distro-licenses >= 1.3.17
BuildRequires: alt-editions-server >= 0.7.16

%if "%status" != "%nil" || "%status_en" != "%nil"
BuildRequires: fonts-ttf-dejavu
%endif

Source: branding.tar

Group: Graphics
Summary: System/Base
License: GPLv2+

%define distro_name ALT Server %version%status_en
%define distro_name_ru Альт Сервер %version%status

%description
Distro-specific packages with design and texts for %distro_name.

%description -l ru_RU.UTF-8
Пакеты оформления для дистрибутива %distro_name_ru.

%package bootloader
Group:   System/Configuration/Boot and Init
Summary: Graphical boot logo for grub2, lilo and syslinux
Summary(ru_RU.UTF-8): Тема для экрана выбора вариантов загрузки (lilo и syslinux) 
License: GPLv2+

Requires(pre):    coreutils
Provides: design-bootloader-system-%theme = %EVR
Provides: design-bootloader-livecd-%theme = %EVR
Provides: design-bootloader-%theme = %EVR
Obsoletes: design-bootloader-system-%theme design-bootloader-livecd-%theme design-bootloader-livecd-%theme design-bootloader-%theme
%branding_add_conflicts %flavour bootloader

%define grub_normal white/light-blue
%define grub_high black/light-gray

%description bootloader
Here you find the graphical boot logo for %distro_name.
Suitable for both lilo and syslinux.

%description bootloader -l ru_RU.UTF-8
В данном пакете находится тема для экрана выбора вариантов загрузки (lilo и syslinux) 
для дистрибутива %distro_name_ru.

%package bootsplash
Summary:  Theme for splash animations during bootup
Summary(ru_RU.UTF-8): Тема для экрана загрузки для дистрибутива %distro_name_ru
License:  Distributable
Group:    System/Configuration/Boot and Init
BuildArch: noarch
Provides: plymouth-theme-%theme = %EVR
%if_enabled flickfree
%define plymouth_theme bgrt-alt
Requires: plymouth-theme-bgrt-alt
%else
%define plymouth_theme %theme
%endif
Requires: plymouth-plugin-script
Requires(pre):   plymouth

%branding_add_conflicts %flavour bootsplash

%description bootsplash
This package contains graphics for boot process for %distro_name
(needs console splash screen enabled).

%description bootsplash -l ru_RU.UTF-8
В данном пакете находится тема для экрана загрузки для дистрибутива
%distro_name_ru.

%package alterator
Summary: Design for alterator for %distro_name
Summary(ru_RU.UTF-8): Тема для "Центра управления системой" и QT для дистрибутива %distro_name_ru
License: GPL
Group: System/Configuration/Other
BuildArch: noarch
Provides: branding-alt-%theme-browser-qt = %EVR
Provides: branding-altlinux-%theme-browser-qt = %EVR
Provides: alterator-icons design-alterator
Provides: design-alterator-%theme = %EVR
Provides: design-alterator-browser-%theme = %EVR

%branding_add_conflicts %flavour alterator
Obsoletes: design-alterator-server design-alterator-desktop design-altertor-browser-desktop  design-altertor-browser-server branding-altlinux-backup-server-alterator
Requires(post,preun): alternatives >= 0.2 alterator

%description alterator
Design for QT and web alterator for %distro_name.

%description alterator -l ru_RU.UTF-8
В данном пакете находится тема для "Центра управления системой" (Alterator)
и модулей библиотеки QT для дистрибутива %distro_name_ru.

%package graphics
Summary: Design for %distro_name
Summary(ru_RU.UTF-8): Тема для дистрибутива %distro_name_ru
License: Different licenses
Group: Graphics
BuildArch: noarch
Provides: design-graphics-%theme = %EVR
Provides: design-graphics = %design_graphics_abi_major.%design_graphics_abi_minor.%design_graphics_abi_bugfix

Requires(post,preun): alternatives >= 0.2
%branding_add_conflicts %flavour graphics

%description graphics
This package contains some graphics for %distro_name design.

%description graphics -l ru_RU.UTF-8
В данном пакете находится необходимые графические элементы для дистрибутива 
%distro_name_ru.

%define provide_list altlinux fedora redhat system altlinux
%define obsolete_list altlinux-release fedora-release redhat-release

%package release
BuildArch: noarch
Summary:  %distro_name release file
Summary(ru_RU.UTF-8): Описание дистрибутива %distro_name_ru
License:  GPL
Group:    System/Configuration/Other
Provides: %(for n in %provide_list; do echo -n "$n-release = %version-%release "; done) altlinux-release-%theme = %EVR
Obsoletes: %obsolete_list
%branding_add_conflicts %flavour release
Requires: alt-os-release
Requires: alt-editions-server

%description release
%distro_name release file.

%description release -l ru_RU.UTF-8
В данном пакете находится описание дистрибутива %distro_name_ru.

%package notes
BuildArch: noarch
Provides:  alt-license-theme = %version alt-notes-%theme
Obsoletes: alt-license-%theme alt-notes-%theme
Requires:  distro-licenses >= 1.3.17
Requires:  alt-editions-server >= 0.7.16
Summary:   Distribution license and release notes
Summary(ru_RU.UTF-8): Лицензия и дополнительные сведения для дистрибутива %distro_name_ru
License:   Distributable
Group:     Documentation
%branding_add_conflicts %flavour notes

%description notes
Distribution license and release notes

%description notes -l ru_RU.UTF-8
В данном пакете находится лицензия и дополнительные сведения
для дистрибутива %distro_name_ru.

%package mate-settings
BuildArch: noarch
Summary: MATE settings for %distro_name
License: Distributable
Group:   Graphical desktop/GNOME
%branding_add_conflicts %flavour mate-settings
%branding_add_conflicts %flavour graphics
Requires(post): lightdm-gtk-greeter
# To avoid install check conflicts
Requires: %name-graphics = %EVR
Conflicts: installer-feature-lightdm-stage3 < 0.1.0-alt1
# Due to /usr/share/install3/lightdm-gtk-greeter.conf
Conflicts: branding-simply-linux-system-settings
Conflicts: branding-alt-workstation-mate-settings
Conflicts: lxde-settings-lxdesktop < 0.3.2-alt2

%description mate-settings
MATE settings for %distro_name

%package gnome-settings
BuildArch: noarch
Summary: GNOME settings for %distro_name
License: Distributable
Group:   Graphical desktop/GNOME
Requires: dconf
%branding_add_conflicts %flavour gnome-settings
%branding_add_conflicts %flavour graphics
Requires(post): libgio
# To avoid install check conflicts
Requires: %name-graphics = %EVR
Conflicts: installer-feature-lightdm-stage3 < 0.1.0-alt1
# Due to /usr/share/install3/lightdm-gtk-greeter.conf
Conflicts: branding-simply-linux-system-settings
Conflicts: branding-alt-workstation-gnome-settings
Conflicts: lxde-settings-lxdesktop < 0.3.2-alt2

%description gnome-settings
GNOME settings for %distro_name

%package slideshow
Summary: Slideshow for %distro_name installer
Summary(ru_RU.UTF-8): Изображения для организации "слайдшоу" в установщике дистрибутива %distro_name_ru
License: Distributable
Group: System/Configuration/Other 
BuildArch: noarch
%branding_add_conflicts %flavour slideshow

%description slideshow
Slideshow for %distro_name installer.

%description slideshow -l ru_RU.UTF-8
В данном пакете находятся изображения для организации "слайдшоу" в установщике 
дистрибутива %distro_name_ru.

%package indexhtml
BuildArch: noarch
Summary:  HTML welcome page for %distro_name
Summary(ru_RU.UTF-8): Стартовая страница для дистрибутива %distro_name_ru
License:  distributable
Group:    System/Base
Provides: indexhtml indexhtml-%theme = %version indexhtml-Desktop = 1:5.0
Obsoletes: indexhtml-desktop indexhtml-Desktop
%branding_add_conflicts %flavour indexhtml

Requires: docs-alt-%theme
Requires(post): indexhtml-common

%description indexhtml
%distro_name welcome page.

%description indexhtml -l ru_RU.UTF-8
В данном пакете содержится стартовая страница для дистрибутива
%distro_name_ru.

%prep
%setup -n branding
# Check for license exists for current version in distro-licenses
test -f /usr/share/distro-licenses/ALT_Server_License/%version/license.all.html
test -f /usr/share/distro-licenses/ALT_Server_License/%version/license.ru.html
%ifarch %e2k
# cf. rm#115880
sed -i 's,#alt-server,&-e2k,' indexhtml/index-*.html.in
%endif

%build
autoconf
THEME=%theme NAME='%Brand %Theme' BRAND_FNAME='%brand' BRAND='%brand' STATUS_EN=%status_en STATUS=%status VERSION=%version PRODUCT_NAME_RU='%distro_name_ru' PRODUCT_NAME='%distro_name' CODENAME='%codename' ICON_THEME='%icon_theme' ALTBRANCH='%altbranch' ./configure
make

%install
%makeinstall
find %buildroot -name \*.in -delete

mkdir -p %buildroot/%_datadir/install3
install mate-settings/lightdm-gtk-greeter.conf %buildroot/%_datadir/install3/lightdm-gtk-greeter.conf
mkdir -p %buildroot/%_datadir/mate-menu
install mate-settings/applications.list-themed %buildroot/%_datadir/mate-menu/applications.list-themed

mkdir -p %buildroot/%_datadir/glib-2.0/schemas
install gnome-settings/*.gschema.override %buildroot/%_datadir/glib-2.0/schemas/

#edition
mkdir -p  %buildroot/%_sysconfdir/dconf/db/default.d/
install systemd/99-edition %buildroot/%_sysconfdir/dconf/db/default.d/

#notes
cp -a %_datadir/alterator/editions/edition_server/{release,final}-notes.*.html %buildroot%_datadir/alt-notes/
for relnotes in %_datadir/alterator/editions/edition_server/final-notes.*.html; do \
   suffix="${relnotes#*final-notes.}"; \
   ln -s $relnotes %buildroot%_datadir/alt-notes/livecd-finish.$suffix; \
done; \

#graphics
mkdir -p %buildroot/%_datadir/design/%theme
cp -a images/product-logo.png %buildroot/%_datadir/design/%theme/icons/system-logo.png
mkdir -p %buildroot/%_iconsdir/hicolor/scalable/apps/
install -m644 images/alt-server-logo.svg %buildroot%_iconsdir/hicolor/scalable/apps/

#bootloader
%ifarch %ix86 x86_64
%pre bootloader
[ -s /usr/share/gfxboot/%theme ] && rm -fr  /usr/share/gfxboot/%theme ||:
[ -s /boot/splash/%theme ] && rm -fr  /boot/splash/%theme ||:
%endif

%post bootloader
[ "$1" -eq 1 ] || exit 0
. shell-config
shell_config_set /etc/sysconfig/grub2 GRUB_COLOR_NORMAL %grub_normal
shell_config_set /etc/sysconfig/grub2 GRUB_COLOR_HIGHLIGHT %grub_high
%if_enabled flickfree
shell_config_del /etc/sysconfig/grub2 GRUB_THEME
%else
shell_config_set /etc/sysconfig/grub2 GRUB_THEME /boot/grub/themes/%theme/theme.txt
%endif

%post gnome-settings
[ "$1" -eq 1 ] || exit 0
/usr/bin/glib-compile-schemas /usr/share/glib-2.0/schemas

%post indexhtml
%_sbindir/indexhtml-update

%files bootloader
/boot/grub/themes/%theme

#bootsplash
%post bootsplash
[ "$1" -eq 1 ] || exit 0
sed -i "s/Theme=.*/Theme=%plymouth_theme/" /etc/plymouth/plymouthd.conf ||:

%files alterator
%config %_altdir/*.rcc
/usr/share/alterator-browser-qt/design/*.rcc
/usr/share/alterator/design/*

%files graphics
%config /etc/alternatives/packages.d/%name-graphics
%_datadir/design
%_iconsdir/hicolor/scalable/apps/*
#_iconsdir/hicolor/*/apps/alt-%theme.png

%files bootsplash
%_datadir/plymouth/themes/%theme/*
%_pixmapsdir/system-logo.png

%files release
%_sysconfdir/*-release
%_prefix/lib/os-release
%_sysconfdir/buildreqs/packages/ignore.d/*
%_sysconfdir/dconf/db/default.d/*

%files notes
%_datadir/alt-notes/livecd-*
%_datadir/alt-notes/release-notes.*
%_datadir/alt-notes/final-notes.*

%files mate-settings
%_datadir/install3/lightdm-gtk-greeter.conf
%_datadir/mate-menu/applications.list-themed

%files gnome-settings
%_datadir/glib-2.0/schemas/*.gschema.override

%files slideshow
/etc/alterator/slideshow.conf
/usr/share/install2/slideshow

%define indexhtmldir %_defaultdocdir/indexhtml

%files indexhtml
%ghost %_defaultdocdir/indexhtml/index.html
%_defaultdocdir/indexhtml/*
%_desktopdir/*
%_datadir/kf5/kio_desktop/DesktopLinks/indexhtml.desktop
%attr(0755,root,root) %_datadir/Desktop/indexhtml.desktop
#_iconsdir/hicolor/*/apps/alt-%theme-desktop.png

%changelog
