%define theme slinux
%define Name Simply Linux
%define codename Giuseppe
%define status %nil

%define brand simply

%define gtk_theme Orchis-Light-Compact
%define icon_theme Papirus
%define xfwm4_theme Orchis-Light-Compact

# Enable compositing on x86_64 only
%ifarch x86_64
%define xfwm4_compositing true
%else
%define xfwm4_compositing false
%endif

%define def_desktop_wallpaper slinux_alt_june_16x10_2560x1600.png

# NOTE: Helper's name must be one of xfce4-settings helpers.

# Browser
%ifarch %e2k %arm mipsel i586 riscv64
# e2k: 2019: no chromium port available
# mipsel: firefox works better now -- iv@
# i586: chromium no longer supports 32bit
%define web_browser firefox
%else
%define web_browser chromium
%endif

# Media Player
%ifarch %e2k %arm mipsel riscv64
%define media_player celluloid
%else
%define media_player vlc
%endif

# Mail Reader
%ifarch riscv64 %e2k
# riscv64: 2021: no thunderbird port available
# e2k: 2025: claws-mail performs better
# NB: use the helper desktop file name here
%define mail_reader sylpheed-claws
%else
%define mail_reader thunderbird
%endif

# File Manager
%define file_manager Thunar

# LibreOffice icon theme
%ifarch %e2k mipsel
# LO5@e2k lacks oxygen icon theme
# On mipsel we have only LO 6.3+ which also lacks it
%define lo_icon_theme auto
%else
%define lo_icon_theme oxygen
%endif

#alterantives weights
%define alterator_browser_weight 52
%define artworks_weight 12

# Default Xfce-4.20 background
%define xfce_default_background xfce-x.svg

%define _unpackaged_files_terminate_build 1

Name: branding-simply-linux
Version: 11.0
Release: alt1

BuildRequires: fonts-ttf-dejavu fonts-ttf-google-droid-serif fonts-ttf-google-droid-sans fonts-ttf-google-droid-sans-mono
BuildRequires(pre): rpm-macros-branding
BuildRequires: libalternatives-devel
BuildRequires: qt6-base-devel

# for licenses
BuildRequires: distro-licenses >= 1.3-alt1

BuildRequires: ImageMagick fontconfig bc

Source: %name-%version.tar

Group: Graphics
Summary: System/Base
License: GPLv2+

%description
Distro-specific packages with design and texts for Simply Linux distribution.

%description -l ru_RU.UTF-8
Пакеты, для дистрибутива "Просто Линукс" (Simply Linux)

%package bootloader
Group: System/Configuration/Boot and Init
Summary: Graphical boot logo for grub2, lilo and syslinux
Summary(ru_RU.UTF-8): Тема для экрана выбора вариантов загрузки (lilo и syslinux) 
License: GPLv2+

Requires: coreutils
Provides: design-bootloader-system-%theme design-bootloader-livecd-%theme design-bootloader-livecd-%theme design-bootloader-%theme branding-alt-%theme-bootloader

Obsoletes: design-bootloader-system-%theme design-bootloader-livecd-%theme design-bootloader-livecd-%theme design-bootloader-%theme branding-alt-%theme-bootloader
%branding_add_conflicts simply-linux bootloader

%define grub_normal white/dark-gray
%define grub_high black/white

%description bootloader
Here you find the graphical boot logo for Simply Linux distribution.
Suitable for both lilo and syslinux.

%description bootloader -l ru_RU.UTF-8
В данном пакете находится тема для экрана выбора вариантов загрузки (lilo и syslinux) 
для дистрибутива "Просто Линукс" (Simply Linux).

%package bootsplash
Summary: Theme for splash animations during bootup
Summary(ru_RU.UTF-8): Тема для экрана загрузки для дистрибутива "Просто Линукс"
License: Distributable
Group:  System/Configuration/Boot and Init
BuildArch: noarch
Provides: plymouth-theme-%theme
Requires: plymouth
Requires: plymouth-theme-bgrt-alt
Requires: plymouth-plugin-label
Requires: fonts-ttf-dejavu

%branding_add_conflicts simply-linux bootsplash

%description bootsplash
This package contains graphics for boot process for Simply Linux
(needs console splash screen enabled).

%description bootsplash -l ru_RU.UTF-8
В данном пакете находится тема для экрана загрузки для дистрибутива
"Просто Линукс" (Simply Linux).

%package alterator
Summary: Design for alterator for Simply Linux 
Summary(ru_RU.UTF-8): Тема для "Центра управления системой" и QT для дистрибутива "Просто Линукс"
License: GPLv2+
Group: System/Configuration/Other
BuildArch: noarch
Provides: design-alterator-browser-%theme  branding-alt-%theme-browser-qt branding-altlinux-%theme-browser-qt
Provides: alterator-icons design-alterator design-alterator-%theme
Obsoletes:  branding-alt-%theme-browser-qt  branding-altlinux-%theme-browser-qt 

# lexicographically first of the village
Conflicts: branding-sisyphus-server-light-alterator

%branding_add_conflicts simply-linux alterator
Obsoletes: design-alterator-server design-alterator-desktop design-altertor-browser-desktop  design-altertor-browser-server branding-altlinux-backup-server-alterator
Requires(post,preun): alternatives >= 0.2 alterator

%description alterator
Design for QT and web alterator for Simply Linux.

%description alterator -l ru_RU.UTF-8
В данном пакете находится тема для "Центра управления системой" (Alterator)
и модулей библиотеки QT для дистрибутива "Просто Линукс" (Simply Linux).

%package graphics
Summary: Design for Simply Linux
Summary(ru_RU.UTF-8): Тема для дистрибутива "Просто Линукс"
License: Different licenses
Group: Graphics
BuildArch: noarch

Provides: design-graphics-%theme  branding-alt-%theme-graphics
Obsoletes:  branding-alt-%theme-graphics design-graphics-%theme
Provides: design-graphics = 12.0.0

Requires(post,preun): alternatives >= 0.2
Requires: icon-theme-hicolor
%branding_add_conflicts simply-linux graphics

%description graphics
This package contains some graphics for Simply Linux design.

%description graphics -l ru_RU.UTF-8
В данном пакете находится необходимые графические элементы для дистрибутива 
"Просто Линукс" (Simply Linux).


%define provide_list altlinux fedora redhat system altlinux
%define obsolete_list altlinux-release fedora-release redhat-release
%define conflicts_list altlinux-release-sisyphus altlinux-release-4.0 altlinux-release-5.0 altlinux-release-5.1 altlinux-release-junior altlinux-release-master altlinux-release-server altlinux-release-terminal altlinux-release-small_business

%package release
Summary: Simply Linux release file
Summary(ru_RU.UTF-8): Описание дистрибутива "Просто Линукс"
License: GPLv2+
Group: System/Configuration/Other
BuildArch: noarch
Requires: alt-os-release
Provides: %(for n in %provide_list; do echo -n "$n-release = %version-%release "; done) altlinux-release-%theme  branding-alt-%theme-release
Obsoletes: %obsolete_list  branding-alt-%theme-release
Conflicts: %conflicts_list
%branding_add_conflicts simply-linux release

%description release
Simply Linux %version release file.

%description release -l ru_RU.UTF-8
В данном пакете находится описание версии %version дистрибутива
"Просто Линукс" (Simply Linux).

%package notes
Provides: alt-license-theme = %version alt-notes-%theme
Obsoletes: alt-license-%theme alt-notes-%theme 
Summary: Distribution license and release notes
Summary(ru_RU.UTF-8): Лицензия и дополнительные сведения для дистрибутива "Просто Линукс"
License: Distributable
Group: Documentation
BuildArch: noarch
Conflicts: alt-notes-children alt-notes-hpc alt-notes-junior alt-notes-junior-sj alt-notes-junior-sm alt-notes-school-server alt-notes-server-lite alt-notes-skif alt-notes-terminal alt-notes-desktop
%branding_add_conflicts simply-linux notes

%description notes
Distribution license and release notes

%description notes -l ru_RU.UTF-8
В данном пакете находится лицензия и дополнительные сведения для версии %version
дистрибутива "Просто Линукс" (Simply Linux).

%package xfce-settings

Summary: default settings for Xfce for Simply linux distribution
License: GPLv2+
Group: Graphical desktop/XFce
Requires: PolicyKit-gnome
Requires: etcskel
Requires: gtk2-theme-orchis gtk3-theme-orchis gtk4-theme-orchis xfwm4-theme-orchis
Requires: icon-theme-Papirus
Requires: gnome-icon-theme
Requires: branding-simply-linux-graphics
Requires: branding-simply-linux-backgrounds11
# plugins added on panel by default
Requires: xfce4-datetime-plugin
Requires: xfce4-places-plugin
Requires: xfce4-pulseaudio-plugin
Requires: xfce4-whiskermenu-plugin
Requires: xfce4-xkb-plugin

Obsoletes: xfce-settings-lite xfce-settings-school-lite
%branding_add_conflicts simply-linux xfce-settings
Conflicts: xfce-settings-simply-linux

%description xfce-settings
This package contains default settings for Xfce for Simply linux distribution.

%package backgrounds11
Group: Graphics
Summary: Backgrounds for SL-10
License: CC-BY-NC-SA-3.0+
BuildArch: noarch
%branding_add_conflicts simply-linux backgrounds11

%description backgrounds11
This package contains backgrounds for Simply Linux 11.

%package slideshow
Summary: Slideshow for Simply Linux %version installer.
Summary(ru_RU.UTF-8): Изображения для организации "слайдшоу" в установщике дистрибутива "Просто Линукс"
License: CC-BY-NC-SA-3.0+
Group: System/Configuration/Other 
BuildArch: noarch
%branding_add_conflicts simply-linux slideshow

%description slideshow
Slideshow for Simply Linux %version installer.

%description slideshow -l ru_RU.UTF-8
В данном пакете находятся изображения для организации "слайдшоу" в установщике 
дистрибутива "Просто Линукс" (Simply Linux).

%package indexhtml
Summary: Simply Linux html welcome page
Summary(ru_RU.UTF-8): Стартовая страница для дистрибутива "Просто Линукс"
License: distributable
Group: System/Base
BuildArch: noarch
Provides: indexhtml indexhtml-%theme = %version indexhtml-Desktop = 1:5.0
Obsoletes: indexhtml-desktop indexhtml-Desktop

%branding_add_conflicts simply-linux indexhtml

Requires: xdg-utils 
Requires: docs-simply-linux
Requires(post): indexhtml-common

%description indexhtml
Simply Linux index.html welcome page.

%description indexhtml -l ru_RU.UTF-8
В данном пакете содержится стартовая страница для дистрибутива
"Просто Линукс" (Simply Linux).

%package menu
Summary: menu for Simply Linux
License: Distributable
Group: Graphical desktop/Other
BuildArch: noarch
Requires(pre): altlinux-freedesktop-menu-common
Requires: altlinux-freedesktop-menu-common

%description menu
Menu for Simply Linux

%package system-settings
Summary: Some system settings for Simply Linux
License: GPLv2+
Group: System/Base
BuildArch: noarch
# Due to /usr/share/install3/lightdm-gtk-greeter.conf
Conflicts: branding-alt-workstation-mate-settings

%description system-settings
Some system settings for Simply Linux.

%prep
%setup -q
cp -a /usr/share/distro-licenses/ALT_Simply_License/license.ru.html.in notes/
cp -a /usr/share/distro-licenses/ALT_Simply_License/license.all.html.in notes/
%ifarch %e2k
# cf. rm#115880
sed -i 's,#alt-simply,&-e2k,' components/indexhtml/index-*.html.in
%endif

%build
autoconf
THEME=%theme NAME='%Name' STATUS=%status VERSION=%version CODENAME='%codename' GTK_THEME=%gtk_theme ICON_THEME=%icon_theme XFWM4_THEME=%xfwm4_theme XFWM4_COMPOSITING=%xfwm4_compositing DEFAULT_WEB_BROWSER=%web_browser DEFAULT_MAIL_READER=%mail_reader DEFAULT_FILE_MANAGER=%file_manager LO_ICON_THEME=%lo_icon_theme MEDIA_PLAYER=%media_player ALTERATOR_BROWSER_WEIGHT=%alterator_browser_weight ./configure
make

%install
%makeinstall


#graphics
mkdir -p %buildroot/%_datadir/design/{%theme,backgrounds}
cp -ar graphics/* %buildroot/%_datadir/design/%theme
# install icons
for s in 16x16 22x22 32x32 48x48 64x64 128x128; do
	mkdir -p %buildroot/%_iconsdir/hicolor/"$s"/apps/
	ln -sr %buildroot/%_datadir/design/%theme/icons/"$s"/slinux.png %buildroot/%_iconsdir/hicolor/"$s"/apps/slinux.png
done
mkdir -p %buildroot/%_iconsdir/hicolor/scalable/apps/
ln -sr %buildroot/%_datadir/design/%theme/icons/scalable/slinux.svg %buildroot/%_iconsdir/hicolor/scalable/apps/slinux.svg

ln -sr %buildroot/%_datadir/wallpapers %buildroot/%_datadir/design/%theme/backgrounds/more

install -d %buildroot//etc/alternatives/packages.d
cat >%buildroot/etc/alternatives/packages.d/%name-graphics <<__EOF__
%_datadir/artworks	%_datadir/design/%theme %artworks_weight
%_datadir/design-current	%_datadir/design/%theme	%artworks_weight
%_datadir/design/current	%_datadir/design/%theme	%artworks_weight
__EOF__

#release
install -pD -m644 /dev/null %buildroot%_sysconfdir/buildreqs/packages/ignore.d/%name-release
install -pD -m644 components/systemd/os-release %buildroot%_prefix/lib/os-release
echo "%Name %version %status (%codename)" >%buildroot%_sysconfdir/altlinux-release
for n in fedora redhat system; do
	ln -s altlinux-release %buildroot%_sysconfdir/$n-release
done

#notes
pushd notes
%makeinstall
popd
ln -s license.ru.html %buildroot%_datadir/alt-notes/license.uk.htm

#slideshow
mkdir -p %buildroot/usr/share/install2/slideshow
mkdir -p %buildroot/etc/alterator
pushd slideshow
cp -a Slides*/  %buildroot/usr/share/install2/slideshow/
popd
# Set English slideshow as default
ln -s Slides-en %buildroot/usr/share/install2/slideshow/Slides
install -m0644 slideshow/slideshow.conf %buildroot/etc/alterator/

#menu
mkdir -p %buildroot/usr/share/slinux-style/applications
install -m644 menu/applications/* %buildroot/usr/share/slinux-style/applications/
mkdir -p %buildroot/etc/xdg/menus/xfce-applications-merged
cp menu/50-xfce-applications.menu %buildroot/etc/xdg/menus/xfce-applications-merged/
mkdir -p %buildroot/usr/share/desktop-directories
cp menu/altlinux-wine.directory %buildroot/usr/share/desktop-directories/

%post bootloader
[ "$1" -eq 1 ] || exit 0
. shell-config
shell_config_set /etc/sysconfig/grub2 GRUB_THEME /boot/grub/themes/%theme/theme.txt
shell_config_set /etc/sysconfig/grub2 GRUB_COLOR_NORMAL %grub_normal
shell_config_set /etc/sysconfig/grub2 GRUB_COLOR_HIGHLIGHT %grub_high

%post indexhtml
%_sbindir/indexhtml-update

#bootsplash
%post bootsplash
if [ "$1" -eq 1 ]; then
	subst "s/Theme=.*/Theme=bgrt-alt/" /etc/plymouth/plymouthd.conf
else
	subst "s/Theme=slinux/Theme=bgrt-alt/" /etc/plymouth/plymouthd.conf
fi

#graphics
%post graphics
[ -e %_datadir/design/slinux/backgrounds/default.png ] || \
	ln -sf default-16x10.png %_datadir/design/slinux/backgrounds/default.png
[ -e %_datadir/design/slinux/backgrounds/xdm.png ] || \
	ln -sf xdm-16x10.png %_datadir/design/slinux/backgrounds/xdm.png

%triggerpostun graphics -- %name-graphics < 10.950-alt3
# Ensure that there is no dangling symlinks
[ -e %_datadir/design/slinux/backgrounds/default.png ] || \
	ln -sf default-16x10.png %_datadir/design/slinux/backgrounds/default.png
[ -e %_datadir/design/slinux/backgrounds/xdm.png ] || \
	ln -sf xdm-16x10.png %_datadir/design/slinux/backgrounds/xdm.png

%post xfce-settings
# Set default SL background
if [ "$(readlink %_datadir/backgrounds/xfce/default-background)" != "%def_desktop_wallpaper" ]; then
	ln -sf "%def_desktop_wallpaper" %_datadir/backgrounds/xfce/default-background ||:
fi

%postun xfce-settings
# Restore default Xfce-4.20 background
if [ "$1" -eq 0 ] && \
		[ "$(readlink %_datadir/backgrounds/xfce/default-background)" = "%def_desktop_wallpaper" ] \
		[ -e %_datadir/backgrounds/xfce/%xfce_default_background ]; then
	ln -sf %xfce_default_background %_datadir/backgrounds/xfce/default-background ||:
fi

%files alterator
%config %_altdir/*.rcc
/usr/share/alterator-browser-qt/design/*.rcc
/usr/share/alterator/design/*

%files graphics
%config /etc/alternatives/packages.d/%name-graphics
%_datadir/design
%_iconsdir/hicolor/*/apps/slinux.*
%ghost %_datadir/design/slinux/backgrounds/default.png
%ghost %_datadir/design/slinux/backgrounds/xdm.png

%files bootloader
/boot/grub/themes/%theme

%files bootsplash

%files release
%_sysconfdir/*-release
%_prefix/lib/os-release
%_sysconfdir/buildreqs/packages/ignore.d/*

%files notes
%_datadir/alt-notes/*

%files xfce-settings
%_sysconfdir/X11/profile.d/zdg-move-templates.sh
%_sysconfdir/X11/profile.d/zdg-move-desktop.sh
/etc/skel/XDG-Templates.skel/
/etc/skel/XDG-Desktop.skel/
/etc/skel/.wm-select
/etc/skel/.config
/etc/skel/.local
/etc/skel/.vimrc
/etc/skel/.gtkrc-2.0

%files backgrounds11
%_datadir/backgrounds/xfce/slinux_*.png

%files slideshow
/etc/alterator/slideshow.conf
/usr/share/install2/slideshow

%define indexhtmldir %_defaultdocdir/indexhtml

%files indexhtml
%ghost %indexhtmldir/index.html
%indexhtmldir/*
%_desktopdir/indexhtml.desktop

%files menu
/usr/share/slinux-style
/etc/xdg/menus/xfce-applications-merged/50-xfce-applications.menu
/usr/share/desktop-directories/altlinux-wine.directory

%files system-settings
%_datadir/polkit-1/rules.d/*.rules
%_datadir/install3/*

%changelog
