%define _unpackaged_files_terminate_build 1
%define pypi_name conan
%define pypi_name_server conan-server
%define mod_name %pypi_name
%define mod_name1 conans

%def_with check

Name: %pypi_name
Version: 2.0.8
Release: alt1
Summary: Conan - The open-source C/C++ package manager (client)
License: MIT
Group: System/Libraries
Url: https://conan.io
Vcs: https://github.com/conan-io/conan
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps -- metadata_client
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps -- metadata_server
%pyproject_builddeps_check
BuildRequires: python3-modules-sqlite3
%endif

%description
Decentralized, open-source (MIT), C/C++ package manager (client).

%package -n python3-module-%pypi_name_server
Summary: Conan - The open-source C/C++ package manager (server)
Group: System/Libraries
Requires: python3-module-%pypi_name
%pyproject_runtimedeps -- metadata_server

%description -n python3-module-%pypi_name_server
Decentralized, open-source (MIT), C/C++ package manager (server).

%prep
%setup
%autopatch -p1
mkdir -p ../%pypi_name_server
cp -a -t ../%pypi_name_server/ .
mv ../%pypi_name_server/setup{_server,}.py
%pyproject_deps_resync_build
%pyproject_deps_resync metadata_client metadata
pushd ../%pypi_name_server
%pyproject_deps_resync metadata_server metadata
popd
%if_with check
%pyproject_deps_resync_check_pipreqfile %mod_name1/requirements_dev.txt
%endif

%build
%pyproject_build
cd ../%pypi_name_server
%pyproject_build

%install
%pyproject_install
cd ../%pypi_name_server
# overwrite everything installed by client package
# today's actual difference is conans/server only
%pyproject_install
rm -r %buildroot%python3_sitelibdir/%mod_name1/test/

%check
%pyproject_run_pytest -ra -Wignore %mod_name1/test/unittests/

%files
%doc README.md
%_bindir/conan
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%mod_name1/
%exclude %python3_sitelibdir/%mod_name1/server/
%exclude %python3_sitelibdir/%mod_name1/conan_server.py
%exclude %python3_sitelibdir/%mod_name1/__pycache__/conan_server.*
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%files -n python3-module-%pypi_name_server
%_bindir/conan_server
%python3_sitelibdir/%mod_name1/server/
%python3_sitelibdir/%mod_name1/conan_server.py
%python3_sitelibdir/%mod_name1/__pycache__/conan_server.*
%python3_sitelibdir/%{pyproject_distinfo %pypi_name_server}/

%changelog
