# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%def_enable opencl

Name: cpu-x
Version: 5.1.1
Release: alt1
Summary: CPU-X is a Free software that gathers information on CPU, motherboard and more
License: GPL-3.0-or-later
Group: System/Kernel and hardware
Url: https://github.com/X0rg/CPU-X
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Buildrequires(pre): rpm-macros-cmake
Buildrequires: gcc-c++ cmake 
BuildRequires: nasm
BuildRequires: libappstream-glib
BuildRequires: pkgconfig(gtkmm-3.0) >= 3.12.0
BuildRequires: pkgconfig(gl)
BuildRequires: pkgconfig(glfw3) >= 3.3
BuildRequires: pkgconfig(vulkan)
BuildRequires: pkgconfig(json-c)
BuildRequires: pkgconfig(libcpuid) >= 0.4.0
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libpci)
BuildRequires: pkgconfig(libproc2)
BuildRequires: pkgconfig(libstatgrab)
BuildRequires: pkgconfig(ncursesw)
BuildRequires: pkgconfig(polkit-gobject-1)
%{?_enable_opencl:BuildRequires: ocl-icd-devel}
Requires: icon-theme-hicolor

ExclusiveArch: %ix86 x86_64

%description
CPU-X is a Free software that gathers information on CPU, motherboard and more.
CPU-X is similar to CPU-Z (Windows), but CPU-X is a Free and Open Source
software designed for GNU/Linux; also, it works on *BSD.
This software is written in C and built with CMake tool.
It can be used in graphical mode by using GTK or in text-based mode by using
NCurses. A dump mode is present from command line.

%prep
%setup
%patch -p1

%build
%cmake \
%if_enabled opencl
    -DWITH_OPENCL=ON \
%endif
%nil

%cmake_build

%install
%cmake_install
%find_lang %name

# Cleanup unpackage files
rm -r %buildroot%_datadir/fish
rm -r %buildroot%_datadir/zsh
rm -r %buildroot%_datadir/locale/zh_Hant

%files -f %name.lang
%_bindir/*
%_datadir/%name
%_iconsdir/hicolor/*/*/*
%_desktopdir/*
%_datadir/polkit-1/actions/*
%_datadir/metainfo/*.appdata.xml
%_datadir/bash-completion/completions/*
%_datadir/glib-2.0/schemas/*
%_prefix/libexec/*

%changelog
