%define version_SingleApplication v3.5.1
%define version_QTaskbarControl 2.0.2
%define version_QOnlineTranslator 1.6.4
%define version_QHotkey 1.5.0
%define version_circle_flags v2.7.0
%define version_Fluent 2023-06-07

Name: crow-translate
Version: 2.11.0
Release: alt1

Summary: A Qt GUI for Google, Yandex and Bing translators
Summary(ru_RU.UTF-8): GUI интерфейс Qt для переводчиков Google, Yandex и Bing

License: GPL-3.0-only and MIT and BSD-3-Clause
Group: System/Internationalization
Url: https://crow-translate.github.io

# Source-url: https://github.com/crow-translate/crow-translate/releases/download/%version/crow-translate-%version-source.tar.gz
Source: %name-%version.tar

# Source1-url: https://github.com/itay-grudev/SingleApplication/archive/refs/tags/%version_SingleApplication.tar.gz
Source1: SingleApplication.tar

# Source2-url: https://github.com/Skycoder42/QTaskbarControl/archive/refs/tags/%version_QTaskbarControl.tar.gz
Source2: QTaskbarControl.tar

# Source3-url: https://github.com/crow-translate/QOnlineTranslator/archive/refs/tags/%version_QOnlineTranslator.tar.gz
Source3: QOnlineTranslator.tar

# Source4-url: https://github.com/Skycoder42/QHotkey/archive/refs/tags/%version_QHotkey.tar.gz
Source4: QHotkey.tar

# Source5-url: https://github.com/HatScripts/circle-flags/archive/refs/tags/%version_circle_flags.tar.gz
Source5: circle-flags.tar

# Source6-url: https://github.com/vinceliuice/Fluent-icon-theme/archive/refs/tags/%version_Fluent.tar.gz
Source6: Fluent-icon-theme.tar

BuildRequires: extra-cmake-modules
BuildRequires: libleptonica-devel
BuildRequires: qt5-multimedia-devel
BuildRequires: qt5-tools-devel
BuildRequires: qt5-x11extras-devel
BuildRequires: kf5-kwayland-devel
BuildRequires: tesseract-devel >= 4.0.0
BuildRequires: libqt5-concurrent
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libqt5-dbus

BuildRequires(pre): rpm-macros-cmake

Requires: tesseract >= 4.0.0
Requires: icon-theme-breeze
Requires: libqt5-svg

%description
A simple and lightweight translator that allows you to translate and voice text
using Google, Yandex and Bing, written in Qt5 for KDE5.
To make the application look native in DE built on GTK, you need to customize
the Qt application style with plugins like qt5ct, adwaita-qt5.
Recommended icons for the Breeze app.

%description -l ru_RU.UTF-8
Простой и легкий переводчик, позволяющий переводить и озвучивать текст с
помощью Google, Yandex и Bing, написанный на Qt5 для KDE5.
Чтобы приложение выглядело родным в DE, построенном на GTK, вам нужно настроить
стиль приложения Qt с помощью плагинов, таких как qt5ct, adwaita-qt5.
Рекомендуемые значки для приложения Breeze.

%prep
%setup

%ifarch %e2k
# workaround of SIGILL in ecf_opt64 from LCC 1.25.23
sed -i -E "s/qOverload<([^>]*)>\(&([^:]*::)/(void(\\2*)(\\1))(\&\\2/" \
	src/mainwindow.cpp
%endif

# preparing external libraries for building
mkdir -p \
    src/qonlinetranslator/ \
    src/third-party/qhotkey/ \
    src/third-party/qtaskbarcontrol/ \
    src/third-party/singleapplication/ \
    src/circle-flags \
    src/Fluent-icon-theme

tar -xf %SOURCE1 -C src/third-party/singleapplication/ --strip-components=1
tar -xf %SOURCE2 -C src/third-party/qtaskbarcontrol/ --strip-components=1
tar -xf %SOURCE3 -C src/qonlinetranslator/ --strip-components=1
tar -xf %SOURCE4 -C src/third-party/qhotkey/ --strip-components=1
tar -xf %SOURCE5 -C src/circle-flags/ --strip-components=1
tar -xf %SOURCE6 -C src/Fluent-icon-theme/ --strip-components=1

# Analog of crow-2.10.0-alt-desktop.patch
subst "s|Categories=Office;Qt;|Categories=Qt;Graphics;OCR;Scanning;|" data/io.crow_translate.CrowTranslate.desktop

# Fix QX11Info: No such file or directory
subst "s|<QX11Info>|<QtX11Extras/QX11Info>|" src/mainwindow.cpp
subst "s|<QX11Info>|<QtX11Extras/QX11Info>|" src/ocr/screengrabbers/abstractscreengrabber.cpp
subst "s|<QX11Info>|<QtX11Extras/QX11Info>|" src/ocr/snippingarea.cpp
subst "s|<QX11Info>|<QtX11Extras/QX11Info>|" src/xdgdesktopportal.cpp

%build
%cmake \
    -DWITH_KWAYLAND=ON

%cmake_build

%install
%cmake_install

%files
%doc README.md COPYING
%_bindir/crow
%_desktopdir/io.crow_translate.CrowTranslate.desktop
%_datadir/crow*/*
%_datadir/metainfo/io.crow_translate.CrowTranslate.metainfo.xml
%_iconsdir/hicolor/*/*/crow-translate*

%changelog
