%add_optflags %optflags_shared
%define soname 19

Name: dcmtk
Version: 3.6.9
Release: alt3

Summary: DCMTK - DICOM Toolkit
License: MIT
Group: Graphics

Url: https://dcmtk.org/dcmtk.php.en
VCS: https://github.com/DCMTK/dcmtk
Source: %name-%version.tar
Patch0: dcmtk-3.6.6-upstream-cve-2024-52333.patch
Patch1: dcmtk-3.6.9-upstream-cve-2025-2357.patch
Patch2: dcmtk-3.6.9-upstream-cve-2025-25472.patch
Patch3: dcmtk-3.6.9-upstream-cve-2025-25474.patch
Patch4: dcmtk-3.6.9-upstream-cve-2025-25475.patch
Patch5: dcmtk-3.6.9-upstream-cve-2025-9732.patch

Requires: lib%name%soname = %EVR
BuildRequires: gcc-c++, zlib-devel, libpng-devel, libtiff-devel
BuildRequires: libxml2-devel, libssl-devel, cmake
BuildRequires: libjpeg-devel

%description
DCMTK is a collection of libraries and applications implementing large parts
the DICOM standard. It includes software for examining, constructing and
converting DICOM image files, handling offline media, sending and receiving
images over a network connection, as well as demonstrative image storage
and worklist servers.

%package -n lib%name%soname
Summary: %name shared libraries
Group: System/Libraries

%description -n lib%name%soname
%name shared libraries

%package -n lib%name-devel
Summary: Headers for building software that uses %name
Group: Development/C
Requires: lib%name%soname = %EVR
Requires: %name = %EVR
Requires: libxml2-devel

%description -n lib%name-devel
Headers for building software that uses %name.
%ifarch %e2k

NB: a project using tuples from this library will fail to build
    as va_arg is intermixed with C++ constructor there.
%endif

%prep
%setup
%autopatch -p1
%ifarch %e2k
sed -i '/"fenv.h" HAVE_FENV_H/d' CMake/GenerateDCMTKConfigure.cmake
# unportable magic with va_args
sed -i -E 's/t(stl|tuple).cc//' ofstd/tests/CMakeLists.txt
sed -i -E '/ofstd_(std_|tuple)/d' ofstd/tests/tests.cc
%endif

%build
%add_optflags -fPIC
%cmake -DBUILD_SHARED_LIBS:BOOL=ON \
	-DDCMTK_INSTALL_LIBDIR=%_lib \
	-DDCMTK_INSTALL_CMKDIR=%_libdir/cmake/dcmtk \
	-DCMAKE_INSTALL_SYSCONFDIR=%_sysconfdir \
	-DDCMTK_DEFAULT_CONFIGURATION_DIR=%_sysconfdir/dcmtk \
	-DDCMTK_WITH_OPENSSL:BOOL=ON \
	-DDCMTK_ENABLE_PRIVATE_TAGS:BOOL=ON \
	-DDCMTK_WITH_XML:BOOL=ON \
	-DDCMTK_WITH_TIFF:BOOL=ON \
	-DDCMTK_WITH_ZLIB:BOOL=ON \
	-DDCMTK_WITH_ICONV:BOOL=ON \
	-DCMAKE_VERBOSE_MAKEFILE=ON \
	-DDCMTK_INSTALL_DATDIC:STRING=share/libdcmtk12 \
	-DDCMTK_USE_CXX11_STL:BOOL=ON \
	-DDCMTK_ENABLE_CXX11:BOOL=ON
%cmake_build

%install
%cmakeinstall_std

%files
%_bindir/*
%_datadir/dcmtk-%version/
%_docdir/*
%_man1dir/*
%config(noreplace) %_sysconfdir/*

%files -n lib%name%soname
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files -n lib%name-devel
%_pkgconfigdir/dcmtk.pc
%_includedir/dcmtk/
%_libdir/*.so
%_libdir/cmake/dcmtk/*.cmake

%changelog
