%define qdoc_found %{expand:%%(if [ -e %_dqt5_bindir/qdoc ]; then echo 1; else echo 0; fi)}
%global qt_module dqtsvg

Name: dqt5-svg
Version: 5.15.13
Release: alt0.dde.1

Group: System/Libraries
Summary: Qt5 - Support for rendering and displaying SVG
Url: http://qt.io/
License: LGPLv2 / GPLv3

Source: %qt_module-everywhere-src-%version.tar

BuildRequires(pre): rpm-build-ubt rpm-macros-dqt5 dqt5-tools
BuildRequires: gcc-c++ glibc-devel dqt5-base-devel > 5.5.0-alt3 pkgconfig(zlib)

# find libraries
%add_findprov_lib_path %_dqt5_libdir

%description
Scalable Vector Graphics (SVG) is an XML-based language for describing
two-dimensional vector graphics. Qt provides classes for rendering and
displaying SVG drawings in widgets and on other paint devices.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: dqt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: dqt5-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libdqt5-svg
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libdqt5-core = %_dqt5_version
Provides: %name = %EVR
%description -n libdqt5-svg
%summary

%prep
%setup -n %qt_module-everywhere-src-%version
syncqt.pl-dqt5 -version %version

%build
%qmake_dqt5
%make_build
%if %qdoc_found
export QT_HASH_SEED=0
%make docs
%endif

%install
%install_dqt5
%if %qdoc_found
%make INSTALL_ROOT=%buildroot install_docs ||:
%endif


%files common
%files -n libdqt5-svg
%doc LICENSE*EXCEPT*
%_dqt5_libdir/libQt?Svg.so.*
%_dqt5_plugindir/iconengines/libqsvgicon.so
%_dqt5_plugindir/imageformats/libqsvg.so

%files devel
%_dqt5_headerdir/QtSvg/
%_dqt5_libdir/lib*.so
%_dqt5_libdir/lib*.prl
%_dqt5_libdatadir/lib*.so
%_dqt5_libdatadir/lib*.prl
%_dqt5_libdir/cmake/Qt?Svg/
%_dqt5_libdir/cmake/Qt?Gui/*Svg*.cmake
%_dqt5_libdir/pkgconfig/Qt5Svg.pc
%_dqt5_archdatadir/mkspecs/modules/qt_lib_svg*.pri

%files doc
%if %qdoc_found
%_dqt5_docdir/*
%endif
%_dqt5_examplesdir/*

%changelog
