Name: dump
Version: 0.4b47
Release: alt1

Summary: Programs for backing up and restoring ext2/ext3 filesystems
License: BSD
Group: Archiving/Backup

URL: http://dump.sourceforge.net/
Source: http://downloads.sourceforge.net/dump/dump-%version.tar.gz
Patch2: dump-0.4b40-include.patch

Requires: rmt = %version-%release

BuildPreReq: glibc-kernheaders

# Automatically added by buildreq on Fri Jun 26 2009
BuildRequires: bzlib-devel libdevmapper-devel libe2fs-devel liblzo2-devel libncurses-devel libreadline-devel libselinux-devel libsepol-devel zlib-devel

%package -n rmt
Summary: Provides certain programs with access to remote tape devices
Group: Archiving/Backup

%description
The %name package contains both dump and restore. Dump examines files in a
filesystem, determines which ones need to be backed up, and copies those files
to a specified disk, tape or other storage medium. The restore command performs
the inverse function of dump; it can restore a full backup of a filesystem.
Subsequent incremental backups can then be layered on top of the full backup.
Single files and directory subtrees may also be restored from full or partial
backups.

%description -n rmt
The rmt utility provides remote access to tape devices for programs like dump
(a filesystem backup program), restore (a program for restoring files from a
backup) and tar (an archiving program).

%prep
%setup
%patch2 -p1

subst s,termcap,tinfo,g ./configure.ac
sed -i '/^#include <sys.un.h>/ a#include <sys/sysmacros.h>' restore/tape.c

%build
%autoreconf
%configure \
	--sbindir=/sbin \
	--enable-rmt \
	--enable-readline \
	--enable-largefile

%install
%makeinstall_std
mkdir %buildroot%_sysconfdir
ln -snfr  %buildroot/sbin/rmt %buildroot%_sysconfdir/rmt
:> %buildroot%_sysconfdir/dumpdates

exit 0
mkdir -p %buildroot{/sbin,%_man8dir}

make install SBINDIR=%buildroot/sbin BINDIR=%buildroot/sbin MANDIR=%buildroot%_man8dir

pushd %buildroot
	ln -s -nf dump ./sbin/rdump
	ln -s -nf restore ./sbin/rrestore
	ln -s -nf dump.8 .%_man8dir/rdump.8
	ln -s -nf restore.8 .%_man8dir/rrestore.8
	chmod a-s ./sbin/rmt
	mkdir -p .%_sysconfdir
	:> .%_sysconfdir/dumpdates
	ln -s -nf ../sbin/rmt .%_sysconfdir/rmt
popd

%files
%doc AUTHORS COPYING ChangeLog KNOWNBUGS MAINTAINERS NEWS README
/sbin/*dump
/sbin/*restore
%_man8dir/*dump.*
%_man8dir/*restore.*
%attr(664,root,disk) %config(noreplace) %_sysconfdir/dumpdates

%files -n rmt
%doc COPYING
/sbin/rmt
%_sysconfdir/rmt
%_man8dir/rmt.*

%changelog
