Name: elfutils
Version: 0.191
Release: alt1

Summary: A collection of utilities and DSOs to handle ELF files and DWARF data
License: GPLv3+ and (GPLv2+ or LGPLv3+)
Group: Development/C
URL: https://sourceware.org/elfutils/
# git://git.altlinux.org/gears/e/elfutils.git
Source: %name-%version-%release.tar

Requires: libelf = %EVR

%def_enable static
%def_enable check
%def_enable libdebuginfod
%def_enable debuginfod
%def_enable debuginfod_urls

BuildRequires: gettext
BuildRequires: bison
BuildRequires: flex

# libstdc++ demangle support
BuildRequires: gcc-c++

# compression support
BuildRequires: bzlib-devel liblzma-devel libzstd-devel zlib-devel

%if_enabled libdebuginfod
BuildRequires: libcurl-devel
%endif

%if_enabled debuginfod
BuildRequires: libarchive-devel
BuildRequires: libmicrohttpd-devel
BuildRequires: libsqlite3-devel
%endif

%{?_enable_check:BuildRequires: /proc}

%define _gnu %nil
%define _configure_script ../configure
%define buildtarget build-%_target_platform

%description
Elfutils is a collection of utilities, including
- eu-stack (to show backtraces),
- eu-nm (for listing symbols from object files),
- eu-size (for listing the section sizes of an object or archive file),
- eu-strip (for discarding symbols),
- eu-readelf (to see the raw ELF file structures),
- eu-elflint (to check for well-formed ELF files),
- eu-elfcompress (to compress or decompress ELF sections).

%package srcfiles
Summary: srcfiles utility from elfutils collection
License: GPLv3+
Group: File tools
Requires: %name = %EVR

%description srcfiles
This package contains srcfiles utility from elfutils collection.

%package devel
Summary: Development libraries to handle compiled objects
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: %name = %EVR
Requires: libasm-devel = %EVR, libdw-devel = %EVR, libelf-devel = %EVR
BuildArch: noarch

%description devel
This package pulls in the libraries to create applications for handling
compiled objects.

%package devel-static
Summary: Static archives to handle compiled objects
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: %name-devel = %EVR
Requires: libasm-devel-static = %EVR
Requires: libdw-devel-static = %EVR
Requires: libelf-devel-static = %EVR
BuildArch: noarch

%description devel-static
This package pulls in static archives with the code to handle compiled objects.

%package -n libasm
Summary: Shared library with a programmable assembler interface
License: GPLv2+ or LGPLv3+
Group: System/Libraries
Requires: libelf = %EVR, libdw = %EVR

%description -n libasm
This package provides a shared library with a programmable assembler
interface.

%package -n libasm-devel
Summary: Development libasm library and header files
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libasm = %EVR
Requires: libelf-devel = %EVR, libdw-devel = %EVR

%description -n libasm-devel

This package contains the library and header files to create libasm
based applications.

%package -n libasm-devel-static
Summary: Static libasm library
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libasm-devel = %EVR
Requires: libelf-devel-static = %EVR, libdw-devel-static = %EVR

%description -n libasm-devel-static
This package contains static libasm library.

%package -n libdw
Summary: Shared library that provides access to the DWARF debug information
License: GPLv2+ or LGPLv3+
Group: System/Libraries
Requires: libelf = %EVR

%description -n libdw
This package provides a shared library that provides access to DWARF
debug information stored inside ELF files.

%package -n libdw-devel
Summary: Development libdw library and header files
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libdw = %EVR
Requires: libelf-devel = %EVR

%description -n libdw-devel
This package contains the library and header files to create libdw based
applications.

%package -n libdw-devel-static
Summary: Static libdw library
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libasm-devel = %EVR, libdw-devel = %EVR
Requires: libelf-devel-static = %EVR

%description -n libdw-devel-static
This package contains static libdw library.

%package -n libelf
Summary: Shared library to read and write ELF files
License: GPLv2+ or LGPLv3+
Group: System/Libraries

%description -n libelf
This package provides a shared library which allows reading and writing
ELF files on a high level.  Third party programs depend on this package
to read internals of ELF files.  The programs of the elfutils package
use it also to generate new ELF files.

%package -n libelf-devel
Summary: Development libelf library and header files
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libelf = %EVR

%description -n libelf-devel
This package contains the library and header files to create
applications for handling compiled objects.  libelf allows you to access
the internals of the ELF object file format, so you can see the
different sections of an ELF file.

%package -n libelf-devel-static
Summary: Static libelf library
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libelf-devel = %EVR

%description -n libelf-devel-static
This package contains static libelf library.

%package -n libdebuginfod
Summary: Shared library to access debuginfod
License: GPLv2+ or LGPLv3+
Group: System/Libraries
Requires: debuginfod-urls = %EVR

%description -n libdebuginfod
This package provides libdebuginfod shared library.

%package -n libdebuginfod-devel
Summary: Development libdebuginfod library and header files
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libdebuginfod = %EVR

%description -n libdebuginfod-devel
This package contains the library and header files for libdebuginfod.

%package -n debuginfod-find
Summary: A command line client for build-id HTTP ELF/DWARF server
License: GPLv3+
Group: Development/C
Requires: libdebuginfod = %EVR

%description -n debuginfod-find
This packages contains debuginfod-find command line client
for build-id HTTP ELF/DWARF server.

%package -n debuginfod-urls
Summary: Shell profiles with canned debuginfod urls
License: GPLv3+ or LGPLv3+
Group: Development/C
BuildArch: noarch
Requires: libelf = %EVR

%description -n debuginfod-urls
This package contains debuginfod url for ALT.

%package -n debuginfod
Summary: Debuginfo-related http file-server daemon
License: GPLv3+ or LGPLv3+
Group: System/Servers

%description -n debuginfod
This package contains debuginfod daemon.

%prep
%setup -n %name-%version-%release

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%add_optflags -fexceptions
%autoreconf
rm -rf %buildtarget
mkdir %buildtarget
cd %buildtarget
%configure \
	--disable-silent-rules \
	--enable-dependency-tracking \
	--enable-maintainer-mode \
	--program-prefix=eu- \
	%{subst_enable libdebuginfod} \
%if_enabled debuginfod_urls
	--enable-debuginfod-urls="https://debuginfod.altlinux.org/" \
%endif
	%{subst_enable debuginfod}
%make_build

%install
%makeinstall_std -C %buildtarget
%find_lang %name
%set_verify_elf_method strict,rpath=normal
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%if_enabled libdebuginfod
%if_disabled debuginfod_urls
# Explicitly remove debuginfod profile.d's as we don't have
# default value for DEBUGINFOD_URLS anyway.
rm %buildroot%_sysconfdir/profile.d/debuginfod.*sh
%endif
%endif

%check
export PATH="%buildroot%_bindir:$PATH" LD_LIBRARY_PATH=%buildroot%_libdir
%make_build -k check -C %buildtarget VERBOSE=1

%files
%_bindir/eu-addr2line
%_bindir/eu-ar
%_bindir/eu-elfclassify
%_bindir/eu-elfcmp
%_bindir/eu-elfcompress
%_bindir/eu-elflint
%_bindir/eu-findtextrel
%_bindir/eu-make-debug-archive
%_bindir/eu-nm
%_bindir/eu-objdump
%_bindir/eu-ranlib
%_bindir/eu-readelf
%_bindir/eu-size
%_bindir/eu-stack
%_bindir/eu-strings
%_bindir/eu-strip
%_bindir/eu-unstrip
%_man1dir/eu-*
%exclude %_man1dir/eu-srcfiles.*

%files srcfiles
%_bindir/eu-srcfiles
%_man1dir/eu-srcfiles.*

%files devel

%if_enabled static
%files devel-static
%endif

%files -n libasm
%_libdir/libasm-*.so
%_libdir/libasm*.so.*

%files -n libasm-devel
%dir %_includedir/elfutils/
%_includedir/elfutils/libasm.h
%_libdir/libasm.so

%if_enabled static
%files -n libasm-devel-static
%_libdir/libasm.a
%endif

%files -n libdw
%_libdir/libdw-*.so
%_libdir/libdw*.so.*

%files -n libdw-devel
%_includedir/dwarf.h
%dir %_includedir/elfutils/
%_includedir/elfutils/libdw.h
%_includedir/elfutils/libdwfl.h
%_includedir/elfutils/libdwelf.h
%_includedir/elfutils/known-dwarf.h
%_libdir/libdw.so
%_pkgconfigdir/libdw.pc

%if_enabled static
%files -n libdw-devel-static
%dir %_includedir/elfutils/
%_libdir/libdw.a
%endif

%files -n libelf -f %name.lang
%doc AUTHORS CONTRIBUTING NEWS NOTES README THANKS
%_libdir/libelf-*.so
%_libdir/libelf*.so.*

%files -n libelf-devel
%_includedir/libelf.h
%_includedir/gelf.h
%_includedir/nlist.h
%dir %_includedir/elfutils/
%_includedir/elfutils/elf-knowledge.h
%_includedir/elfutils/version.h
%_libdir/libelf.so
%_pkgconfigdir/libelf.pc
%_man3dir/elf_*

%if_enabled static
%files -n libelf-devel-static
%_libdir/libelf.a
%endif

%if_enabled libdebuginfod
%files -n libdebuginfod
%_libdir/libdebuginfod-*.so
%_libdir/libdebuginfod.so.*
%_man7dir/debuginfod-client-config.7*

%files -n libdebuginfod-devel
%dir %_includedir/elfutils/
%_includedir/elfutils/debuginfod.h
%_libdir/libdebuginfod.so
%_pkgconfigdir/libdebuginfod.pc
%_man3dir/debuginfod*.3*

%files -n debuginfod-find
%_bindir/debuginfod-find
%_man1dir/debuginfod-find.1*
%endif

%if_enabled debuginfod
%files -n debuginfod
%_bindir/debuginfod
%_man8dir/debuginfod.*
%endif

%if_enabled libdebuginfod
%if_enabled debuginfod_urls
%files -n debuginfod-urls
%dir %_sysconfdir/debuginfod/
%config(noreplace) %_sysconfdir/debuginfod/altlinux.urls
%config(noreplace) %_sysconfdir/profile.d/debuginfod.*sh
%endif
%endif

%changelog
