%def_without x
%def_enable gpt
%def_disable ocfs2
%def_disable static
%def_disable pretty_logs

Name: evms
Version: 2.5.5
Release: alt88

Summary: Enterprise Volume Management System utilities
License: GPL
Group: System/Kernel and hardware
Url: http://www.sourceforge.net/projects/evms

Source: %name-%version-%release.tar

BuildRequires: glib2-devel libe2fs-devel libncurses-devel libreadline-devel libuuid-devel
BuildRequires: libblkid-devel
BuildRequires: libcryptsetup-devel >= 1.4.0
BuildRequires: libbtrfs-devel

%if_enabled pretty_logs
BuildRequires: gcc-c++
%endif

%if_with x
BuildRequires: gtk+-devel
%endif

%package -n lib%name
Summary: Enterprise Volume Management System libraries
Group: System/Libraries
Requires: mdadm-tool

%package -n lib%name-devel
Summary: Enterprise Volume Management System development part
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version-%release

%package -n lib%name-devel-static
Summary: Enterprise Volume Management System static libs
Group: Development/C
Requires: lib%name = %version-%release

%package -n %name-cli
Summary: EVMS commandline tool
Group: System/Kernel and hardware
Requires: evms = %version-%release

%package -n %name-ncurses
Summary: EVMS UI
Group: System/Kernel and hardware
Requires: evms = %version-%release

%package -n %name-gui
Summary: EVMS GUI
Group: System/Kernel and hardware
Requires: evms = %version-%release

%package -n %name-test
Summary: EVMS Tests
Group: Development/C
Requires: %name-cli = %EVR
Requires: installer-scripts-remount-stage2
BuildArch: noarch

%description
This package contains the user-space tools needed to manage EVMS (Enterprise
Volume Management System) volumes.

In order to use these user-space tools, you must also have your kernel patched
with the most recent EVMS code. This code is available in the source package
on the project web page http://www.sf.net/projects/evms/

Please see the EVMS-HOWTO on the project web page or in the source package
for detailed instructions on patching your kernel with EVMS and using the
tools after installation.

%description -n lib%name
This package contains libs needed to manage EVMS (Enterprise
Volume Management System) volumes.

%description -n lib%name-devel
This package contains develop tools needed to manage EVMS (Enterprise
Volume Management System) volumes.

%description -n lib%name-devel-static
This package contains static libs for develop tools needed to manage EVMS
(Enterprise Volume Management System) volumes.

%description -n %name-cli
Command line tool for EVMS

%description -n %name-ncurses
Ncurses ui tool for EVMS

%description -n %name-gui
GTK+ ui tool for EVMS

%description -n %name-test
Tests for EVMS

%prep
%setup
# die early, die often
sed -i /SEGV/d engine/faulthdlr.c

%build
%define _optlevel 0
%autoreconf
%add_optflags -DEVMS_DEBUG -std=gnu89
%configure  --libdir=/%_lib --sbindir=/sbin \
    --disable-s390 \
    %{subst_enable gpt} \
    %{subst_enable ocfs2} \
    %{!?_with_x: --disable-gui --disable-gtktest} \
    %{subst_enable static} \
    %{subst_enable pretty_logs} \
    #

%make_build LD_LIBRARY_PATH=%buildroot/%_lib
make -C tests evms_deactivate

%install
mkdir -p %buildroot{%_sysconfdir,%_libdir,%_sbindir/sbin}
%make_install DESTDIR=%buildroot prefix=%buildroot%_prefix install
install -pD -m 0755 altlinux/startevms %buildroot/sbin
install -pm0755 tests/evms_deactivate %buildroot/sbin
install -pm0644 tests/evms_deactivate.8 %buildroot%_man8dir
install -pm0755 tests/cli_scripts/evms-raid-test %buildroot/%_sbindir
mv %buildroot/sbin/%{?_with_x:{evmsn,evmsgui}}%{!?_with_x:evmsn} %buildroot%_sbindir/

for f in %buildroot/%_lib/*evms.so; do
readlink $f && ln -sf ../../%_lib/`readlink $f` %buildroot%_libdir/${f##*/}
done
rm -f %buildroot/%_lib/*evms-2.5.so

mkdir -p %buildroot%_sysconfdir/sysconfig
cat <<EOF > %buildroot%_sysconfdir/sysconfig/%name
# if 'yes' tune evms.conf during evms startup
# to avoid scans on nonexistent legacy devices
EVMS_RECONFIG=no
EOF

%files
%doc doc/linuxrc ChangeLog INSTALL* README PLUGIN.IDS TERMINOLOGY
%config(noreplace) %_sysconfdir/sysconfig/%name
/sbin/startevms
/sbin/%{name}_*
%_man8dir/%{name}_*

%files -n lib%name
%config(noreplace) %_sysconfdir/%name.conf
/%_lib/%name
/%_lib/lib%name-*.so.*
%if_enabled pretty_logs
/%_lib/libevms-logfmt.so
%endif

%files -n lib%name-devel
%_libdir/lib%name.so
%_includedir/%name

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib%name.a
%endif #static

%files -n %name-cli
/sbin/%name
%_man8dir/%name.*

%files -n %name-ncurses
%_sbindir/%{name}n

%if_with x
%files -n %name-gui
%_sbindir/%{name}gui
%endif

%files -n %name-test
%_sbindir/evms-raid-test

%changelog
