Group: System/Fonts/True type
%define oldname tangerine-fonts
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global fontname tangerine
%global fontconf 62-%{fontname}.conf

Name:           fonts-ttf-tangerine
Version:        1.3
Release:        alt1_9
Summary:        Tangerine is a calligraphy font inspired by many italic chancery hands 

License:        OFL
URL:            https://fonts.google.com/specimen/Tangerine
Source0:        https://github.com/google/fonts/raw/master/ofl/tangerine/Tangerine_Regular.ttf
Source1:        https://github.com/google/fonts/raw/master/ofl/tangerine/Tangerine_Bold.ttf
Source2:        https://raw.githubusercontent.com/google/fonts/master/ofl/tangerine/OFL.txt
Source3:        %{oldname}-fontconfig.conf
Source4:        %{fontname}.metainfo.xml

BuildArch:      noarch
BuildRequires:  fontpackages-devel
Source44: import.info

%description
Tangerine is a calligraphy font inspired by many italic chancery hands from
the 16-17th century. Its tall ascender, the most distinct characteristic of
this type, takes a wide line space between lines and gives it a graceful
texture. It is generally advisable to use Tangerine for a title or short text
at large size because of the short height of lowercase letters. Tangerine is
produced by Japanese type designer Toshi Omagari and was named after a woman
who encouraged him to begin this work.

%prep
%setup -n %{oldname}-%{version} -q -c -T

cp -p %{SOURCE0} %{SOURCE1} %{SOURCE2} .


%build


%install
install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p *.ttf %{buildroot}%{_fontdir}

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

install -m 0644 -p %{SOURCE3} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}
ln -s %{_fontconfig_templatedir}/%{fontconf} \
      %{buildroot}%{_fontconfig_confdir}/%{fontconf}

# Add AppStream metadata
install -Dm 0644 -p %{SOURCE4} \
        %{buildroot}%{_datadir}/appdata/%{fontname}.metainfo.xml
# generic fedora font import transformations
# move fonts to corresponding subdirs if any
for fontpatt in OTF TTF TTC otf ttf ttc pcf pcf.gz bdf afm pfa pfb; do
    case "$fontpatt" in 
	pcf*|bdf*) type=bitmap;;
	tt*|TT*) type=ttf;;
	otf|OTF) type=otf;;
	afm*|pf*) type=type1;;
    esac
    find $RPM_BUILD_ROOT/usr/share/fonts -type f -name '*.'$fontpatt | while read i; do
	j=`echo "$i" | sed -e s,/usr/share/fonts/,/usr/share/fonts/$type/,`;
	install -Dm644 "$i" "$j";
	rm -f "$i";
	olddir=`dirname "$i"`;
	mv -f "$olddir"/{encodings.dir,fonts.{dir,scale,alias}} `dirname "$j"`/ 2>/dev/null ||:
	rmdir -p "$olddir" 2>/dev/null ||:
    done
done
# kill invalid catalogue links
if [ -d $RPM_BUILD_ROOT/etc/X11/fontpath.d ]; then
    find -L $RPM_BUILD_ROOT/etc/X11/fontpath.d -type l -print -delete ||:
    # relink catalogue
    find $RPM_BUILD_ROOT/usr/share/fonts -name fonts.dir | while read i; do
	pri=10;
	j=`echo $i | sed -e s,$RPM_BUILD_ROOT/usr/share/fonts/,,`; type=${j%%%%/*}; 
	pre_stem=${j##$type/}; stem=`dirname $pre_stem|sed -e s,/,-,g`;
	case "$type" in 
	    bitmap) pri=10;;
	    ttf|ttf) pri=50;;
	    type1) pri=40;;
	esac
	ln -s /usr/share/fonts/$j $RPM_BUILD_ROOT/etc/X11/fontpath.d/"$stem:pri=$pri"
    done ||:
fi

%files
%{_fontconfig_templatedir}/%{fontconf}
%config(noreplace) %{_fontconfig_confdir}/%{fontconf}
%{_fontbasedir}/*/%{_fontstem}/*.ttf
%doc OFL.txt
%{_datadir}/appdata/%{fontname}.metainfo.xml


%changelog
