# vim: set ft=spec: -*- rpm-spec -*-

%define        pkgname ruby-prof

Name:          gem-%pkgname
Version:       0.18.0
Release:       alt1
Summary:       Fast code profiler for Ruby
Group:         Development/Ruby
License:       BSD-2-Clause
Url:           https://github.com/ruby-prof/ruby-prof
Vcs:           https://github.com/ruby-prof/ruby-prof.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby

%add_findreq_skiplist %ruby_gemslibdir/**/*

%description
ruby-prof is a fast code profiler for MRI Ruby. Its features include:

* Speed - it is a C extension and therefore many times faster than the standard
  Ruby profiler.
* Modes - Ruby prof can measure a number of different parameters, including call
  times, memory usage and object allocations.
* Reports - can generate text and cross-referenced html reports
 - Flat Profiles - similar to the reports generated by the standard Ruby
   profiler
 - Graph profiles - similar to GProf, these show how long a method runs, which
   methods call it and which methods it calls.
 - Call tree profiles - outputs results in the calltree format suitable for
   the KCacheGrind profiling tool.
 - Many more - see reports section of this README.
* Threads - supports profiling multiple threads simultaneously


%package       -n %pkgname
Summary:       Executable file for %gemname gem
Summary(ru_RU.UTF-8): Исполнямка для самоцвета %gemname
Group:         Development/Ruby
BuildArch:     noarch

%description   -n %pkgname
Executable file for %gemname gem.

%description   -n %pkgname -l ru_RU.UTF8
Исполнямка для %gemname самоцвета.


%package       doc
Summary:       Documentation files for %gemname gem
Group:         Development/Documentation
BuildArch:     noarch
Provides:      ruby-%pkgname-doc
Obsoletes:     ruby-%pkgname-doc

%description   doc
Documentation files for %gemname gem.


%package       devel
Summary:       Development files for %gemname gem
Group:         Development/Documentation
BuildArch:     noarch

%description   devel
Development files for %gemname gem.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         doc
%ruby_gemdocdir

%files         devel
%ruby_includedir/*

%files         -n %pkgname
%_bindir/%{pkgname}*


%changelog
